/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.elasticsearch._types.ShardStatistics;
import co.elastic.clients.elasticsearch.indices.data_streams_stats.DataStreamsStatsItem;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class DataStreamsStatsResponse
implements JsonpSerializable {
    private final ShardStatistics shards;
    private final int backingIndices;
    private final int dataStreamCount;
    @Nullable
    private final String totalStoreSizes;
    private final int totalStoreSizeBytes;
    private final List<DataStreamsStatsItem> dataStreams;
    public static final JsonpDeserializer<DataStreamsStatsResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DataStreamsStatsResponse::setupDataStreamsStatsResponseDeserializer, Builder::build);

    public DataStreamsStatsResponse(Builder builder) {
        this.shards = Objects.requireNonNull(builder.shards, "_shards");
        this.backingIndices = Objects.requireNonNull(builder.backingIndices, "backing_indices");
        this.dataStreamCount = Objects.requireNonNull(builder.dataStreamCount, "data_stream_count");
        this.totalStoreSizes = builder.totalStoreSizes;
        this.totalStoreSizeBytes = Objects.requireNonNull(builder.totalStoreSizeBytes, "total_store_size_bytes");
        this.dataStreams = ModelTypeHelper.unmodifiableNonNull(builder.dataStreams, "data_streams");
    }

    public DataStreamsStatsResponse(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public ShardStatistics shards() {
        return this.shards;
    }

    public int backingIndices() {
        return this.backingIndices;
    }

    public int dataStreamCount() {
        return this.dataStreamCount;
    }

    @Nullable
    public String totalStoreSizes() {
        return this.totalStoreSizes;
    }

    public int totalStoreSizeBytes() {
        return this.totalStoreSizeBytes;
    }

    public List<DataStreamsStatsItem> dataStreams() {
        return this.dataStreams;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("_shards");
        this.shards.serialize(generator, mapper);
        generator.writeKey("backing_indices");
        generator.write(this.backingIndices);
        generator.writeKey("data_stream_count");
        generator.write(this.dataStreamCount);
        if (this.totalStoreSizes != null) {
            generator.writeKey("total_store_sizes");
            generator.write(this.totalStoreSizes);
        }
        generator.writeKey("total_store_size_bytes");
        generator.write(this.totalStoreSizeBytes);
        generator.writeKey("data_streams");
        generator.writeStartArray();
        for (DataStreamsStatsItem item0 : this.dataStreams) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupDataStreamsStatsResponseDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::shards, ShardStatistics._DESERIALIZER, "_shards", new String[0]);
        op.add(Builder::backingIndices, JsonpDeserializer.integerDeserializer(), "backing_indices", new String[0]);
        op.add(Builder::dataStreamCount, JsonpDeserializer.integerDeserializer(), "data_stream_count", new String[0]);
        op.add(Builder::totalStoreSizes, JsonpDeserializer.stringDeserializer(), "total_store_sizes", new String[0]);
        op.add(Builder::totalStoreSizeBytes, JsonpDeserializer.integerDeserializer(), "total_store_size_bytes", new String[0]);
        op.add(Builder::dataStreams, JsonpDeserializer.arrayDeserializer(DataStreamsStatsItem._DESERIALIZER), "data_streams", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<DataStreamsStatsResponse> {
        private ShardStatistics shards;
        private Integer backingIndices;
        private Integer dataStreamCount;
        @Nullable
        private String totalStoreSizes;
        private Integer totalStoreSizeBytes;
        private List<DataStreamsStatsItem> dataStreams;

        public Builder shards(ShardStatistics value) {
            this.shards = value;
            return this;
        }

        public Builder shards(Function<ShardStatistics.Builder, ObjectBuilder<ShardStatistics>> fn) {
            return this.shards(fn.apply(new ShardStatistics.Builder()).build());
        }

        public Builder backingIndices(int value) {
            this.backingIndices = value;
            return this;
        }

        public Builder dataStreamCount(int value) {
            this.dataStreamCount = value;
            return this;
        }

        public Builder totalStoreSizes(@Nullable String value) {
            this.totalStoreSizes = value;
            return this;
        }

        public Builder totalStoreSizeBytes(int value) {
            this.totalStoreSizeBytes = value;
            return this;
        }

        public Builder dataStreams(List<DataStreamsStatsItem> value) {
            this.dataStreams = value;
            return this;
        }

        public Builder dataStreams(DataStreamsStatsItem ... value) {
            this.dataStreams = Arrays.asList(value);
            return this;
        }

        public Builder addDataStreams(DataStreamsStatsItem value) {
            if (this.dataStreams == null) {
                this.dataStreams = new ArrayList<DataStreamsStatsItem>();
            }
            this.dataStreams.add(value);
            return this;
        }

        public Builder dataStreams(Function<DataStreamsStatsItem.Builder, ObjectBuilder<DataStreamsStatsItem>> fn) {
            return this.dataStreams(fn.apply(new DataStreamsStatsItem.Builder()).build());
        }

        public Builder addDataStreams(Function<DataStreamsStatsItem.Builder, ObjectBuilder<DataStreamsStatsItem>> fn) {
            return this.addDataStreams(fn.apply(new DataStreamsStatsItem.Builder()).build());
        }

        @Override
        public DataStreamsStatsResponse build() {
            return new DataStreamsStatsResponse(this);
        }
    }
}

