/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.enrich;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.enrich.Policy;
import co.elastic.clients.elasticsearch.enrich.PutPolicyResponse;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class PutPolicyRequest
extends RequestBase
implements JsonpSerializable {
    private final String name;
    @Nullable
    private final Policy geoMatch;
    @Nullable
    private final Policy match;
    public static final JsonpDeserializer<PutPolicyRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PutPolicyRequest::setupPutPolicyRequestDeserializer, Builder::build);
    public static final Endpoint<PutPolicyRequest, PutPolicyResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<PutPolicyRequest, PutPolicyResponse>(request -> "PUT", request -> {
        boolean _name = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_enrich");
            buf.append("/policy");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.name, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, PutPolicyResponse._DESERIALIZER);

    public PutPolicyRequest(Builder builder) {
        this.name = Objects.requireNonNull(builder.name, "name");
        this.geoMatch = builder.geoMatch;
        this.match = builder.match;
    }

    public PutPolicyRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String name() {
        return this.name;
    }

    @Nullable
    public Policy geoMatch() {
        return this.geoMatch;
    }

    @Nullable
    public Policy match() {
        return this.match;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.geoMatch != null) {
            generator.writeKey("geo_match");
            this.geoMatch.serialize(generator, mapper);
        }
        if (this.match != null) {
            generator.writeKey("match");
            this.match.serialize(generator, mapper);
        }
    }

    protected static void setupPutPolicyRequestDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::geoMatch, Policy._DESERIALIZER, "geo_match", new String[0]);
        op.add(Builder::match, Policy._DESERIALIZER, "match", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<PutPolicyRequest> {
        private String name;
        @Nullable
        private Policy geoMatch;
        @Nullable
        private Policy match;

        public Builder name(String value) {
            this.name = value;
            return this;
        }

        public Builder geoMatch(@Nullable Policy value) {
            this.geoMatch = value;
            return this;
        }

        public Builder geoMatch(Function<Policy.Builder, ObjectBuilder<Policy>> fn) {
            return this.geoMatch(fn.apply(new Policy.Builder()).build());
        }

        public Builder match(@Nullable Policy value) {
            this.match = value;
            return this;
        }

        public Builder match(Function<Policy.Builder, ObjectBuilder<Policy>> fn) {
            return this.match(fn.apply(new Policy.Builder()).build());
        }

        @Override
        public PutPolicyRequest build() {
            return new PutPolicyRequest(this);
        }
    }
}

