/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster.stats;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class FieldTypes
implements JsonpSerializable {
    private final String name;
    private final int count;
    private final int indexCount;
    @Nullable
    private final Integer scriptCount;
    public static final JsonpDeserializer<FieldTypes> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FieldTypes::setupFieldTypesDeserializer, Builder::build);

    public FieldTypes(Builder builder) {
        this.name = Objects.requireNonNull(builder.name, "name");
        this.count = Objects.requireNonNull(builder.count, "count");
        this.indexCount = Objects.requireNonNull(builder.indexCount, "index_count");
        this.scriptCount = builder.scriptCount;
    }

    public FieldTypes(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String name() {
        return this.name;
    }

    public int count() {
        return this.count;
    }

    public int indexCount() {
        return this.indexCount;
    }

    @Nullable
    public Integer scriptCount() {
        return this.scriptCount;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("name");
        generator.write(this.name);
        generator.writeKey("count");
        generator.write(this.count);
        generator.writeKey("index_count");
        generator.write(this.indexCount);
        if (this.scriptCount != null) {
            generator.writeKey("script_count");
            generator.write(this.scriptCount.intValue());
        }
    }

    protected static void setupFieldTypesDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name", new String[0]);
        op.add(Builder::count, JsonpDeserializer.integerDeserializer(), "count", new String[0]);
        op.add(Builder::indexCount, JsonpDeserializer.integerDeserializer(), "index_count", new String[0]);
        op.add(Builder::scriptCount, JsonpDeserializer.integerDeserializer(), "script_count", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<FieldTypes> {
        private String name;
        private Integer count;
        private Integer indexCount;
        @Nullable
        private Integer scriptCount;

        public Builder name(String value) {
            this.name = value;
            return this;
        }

        public Builder count(int value) {
            this.count = value;
            return this;
        }

        public Builder indexCount(int value) {
            this.indexCount = value;
            return this;
        }

        public Builder scriptCount(@Nullable Integer value) {
            this.scriptCount = value;
            return this;
        }

        @Override
        public FieldTypes build() {
            return new FieldTypes(this);
        }
    }
}

