/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.query_dsl;

import co.elastic.clients.elasticsearch._types.VersionType;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class LikeDocument
implements JsonpSerializable {
    @Nullable
    private final JsonData doc;
    @Nullable
    private final List<String> fields;
    @Nullable
    private final String id;
    @Nullable
    private final String type;
    @Nullable
    private final String index;
    @Nullable
    private final Map<String, String> perFieldAnalyzer;
    @Nullable
    private final String routing;
    @Nullable
    private final Long version;
    @Nullable
    private final VersionType versionType;
    public static final JsonpDeserializer<LikeDocument> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, LikeDocument::setupLikeDocumentDeserializer, Builder::build);

    public LikeDocument(Builder builder) {
        this.doc = builder.doc;
        this.fields = ModelTypeHelper.unmodifiable(builder.fields);
        this.id = builder.id;
        this.type = builder.type;
        this.index = builder.index;
        this.perFieldAnalyzer = ModelTypeHelper.unmodifiable(builder.perFieldAnalyzer);
        this.routing = builder.routing;
        this.version = builder.version;
        this.versionType = builder.versionType;
    }

    public LikeDocument(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public JsonData doc() {
        return this.doc;
    }

    @Nullable
    public List<String> fields() {
        return this.fields;
    }

    @Nullable
    public String id() {
        return this.id;
    }

    @Nullable
    public String type() {
        return this.type;
    }

    @Nullable
    public String index() {
        return this.index;
    }

    @Nullable
    public Map<String, String> perFieldAnalyzer() {
        return this.perFieldAnalyzer;
    }

    @Nullable
    public String routing() {
        return this.routing;
    }

    @Nullable
    public Long version() {
        return this.version;
    }

    @Nullable
    public VersionType versionType() {
        return this.versionType;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.doc != null) {
            generator.writeKey("doc");
            this.doc.serialize(generator, mapper);
        }
        if (this.fields != null) {
            generator.writeKey("fields");
            generator.writeStartArray();
            for (String string : this.fields) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (this.id != null) {
            generator.writeKey("_id");
            generator.write(this.id);
        }
        if (this.type != null) {
            generator.writeKey("_type");
            generator.write(this.type);
        }
        if (this.index != null) {
            generator.writeKey("_index");
            generator.write(this.index);
        }
        if (this.perFieldAnalyzer != null) {
            generator.writeKey("per_field_analyzer");
            generator.writeStartObject();
            for (Map.Entry entry : this.perFieldAnalyzer.entrySet()) {
                generator.writeKey((String)entry.getKey());
                generator.write((String)entry.getValue());
            }
            generator.writeEnd();
        }
        if (this.routing != null) {
            generator.writeKey("routing");
            generator.write(this.routing);
        }
        if (this.version != null) {
            generator.writeKey("version");
            generator.write(this.version.longValue());
        }
        if (this.versionType != null) {
            generator.writeKey("version_type");
            this.versionType.serialize(generator, mapper);
        }
    }

    protected static void setupLikeDocumentDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::doc, JsonData._DESERIALIZER, "doc", new String[0]);
        op.add(Builder::fields, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "fields", new String[0]);
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "_id", new String[0]);
        op.add(Builder::type, JsonpDeserializer.stringDeserializer(), "_type", new String[0]);
        op.add(Builder::index, JsonpDeserializer.stringDeserializer(), "_index", new String[0]);
        op.add(Builder::perFieldAnalyzer, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringDeserializer()), "per_field_analyzer", new String[0]);
        op.add(Builder::routing, JsonpDeserializer.stringDeserializer(), "routing", new String[0]);
        op.add(Builder::version, JsonpDeserializer.longDeserializer(), "version", new String[0]);
        op.add(Builder::versionType, VersionType._DESERIALIZER, "version_type", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<LikeDocument> {
        @Nullable
        private JsonData doc;
        @Nullable
        private List<String> fields;
        @Nullable
        private String id;
        @Nullable
        private String type;
        @Nullable
        private String index;
        @Nullable
        private Map<String, String> perFieldAnalyzer;
        @Nullable
        private String routing;
        @Nullable
        private Long version;
        @Nullable
        private VersionType versionType;

        public Builder doc(@Nullable JsonData value) {
            this.doc = value;
            return this;
        }

        public Builder fields(@Nullable List<String> value) {
            this.fields = value;
            return this;
        }

        public Builder fields(String ... value) {
            this.fields = Arrays.asList(value);
            return this;
        }

        public Builder addFields(String value) {
            if (this.fields == null) {
                this.fields = new ArrayList<String>();
            }
            this.fields.add(value);
            return this;
        }

        public Builder id(@Nullable String value) {
            this.id = value;
            return this;
        }

        public Builder type(@Nullable String value) {
            this.type = value;
            return this;
        }

        public Builder index(@Nullable String value) {
            this.index = value;
            return this;
        }

        public Builder perFieldAnalyzer(@Nullable Map<String, String> value) {
            this.perFieldAnalyzer = value;
            return this;
        }

        public Builder putPerFieldAnalyzer(String key, String value) {
            if (this.perFieldAnalyzer == null) {
                this.perFieldAnalyzer = new HashMap<String, String>();
            }
            this.perFieldAnalyzer.put(key, value);
            return this;
        }

        public Builder routing(@Nullable String value) {
            this.routing = value;
            return this;
        }

        public Builder version(@Nullable Long value) {
            this.version = value;
            return this;
        }

        public Builder versionType(@Nullable VersionType value) {
            this.versionType = value;
            return this;
        }

        @Override
        public LikeDocument build() {
            return new LikeDocument(this);
        }
    }
}

