/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.query_dsl;

import co.elastic.clients.elasticsearch._types.GeoDistanceType;
import co.elastic.clients.elasticsearch._types.query_dsl.GeoValidationMethod;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryBase;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class GeoDistanceQuery
extends QueryBase
implements QueryVariant {
    private final String field;
    private final JsonValue location;
    @Nullable
    private final String distance;
    @Nullable
    private final GeoDistanceType distanceType;
    @Nullable
    private final GeoValidationMethod validationMethod;
    public static final JsonpDeserializer<GeoDistanceQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GeoDistanceQuery::setupGeoDistanceQueryDeserializer, Builder::build);

    public GeoDistanceQuery(Builder builder) {
        super(builder);
        this.field = Objects.requireNonNull(builder.field, "field");
        this.location = Objects.requireNonNull(builder.location, "location");
        this.distance = builder.distance;
        this.distanceType = builder.distanceType;
        this.validationMethod = builder.validationMethod;
    }

    public GeoDistanceQuery(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "geo_distance";
    }

    public String field() {
        return this.field;
    }

    public JsonValue location() {
        return this.location;
    }

    @Nullable
    public String distance() {
        return this.distance;
    }

    @Nullable
    public GeoDistanceType distanceType() {
        return this.distanceType;
    }

    @Nullable
    public GeoValidationMethod validationMethod() {
        return this.validationMethod;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey(this.field);
        generator.write(this.location);
        super.serializeInternal(generator, mapper);
        if (this.distance != null) {
            generator.writeKey("distance");
            generator.write(this.distance);
        }
        if (this.distanceType != null) {
            generator.writeKey("distance_type");
            this.distanceType.serialize(generator, mapper);
        }
        if (this.validationMethod != null) {
            generator.writeKey("validation_method");
            this.validationMethod.serialize(generator, mapper);
        }
    }

    protected static void setupGeoDistanceQueryDeserializer(DelegatingDeserializer<Builder> op) {
        QueryBase.setupQueryBaseDeserializer(op);
        op.add(Builder::distance, JsonpDeserializer.stringDeserializer(), "distance", new String[0]);
        op.add(Builder::distanceType, GeoDistanceType._DESERIALIZER, "distance_type", new String[0]);
        op.add(Builder::validationMethod, GeoValidationMethod._DESERIALIZER, "validation_method", new String[0]);
        op.setUnknownFieldHandler((builder, name, parser, mapper) -> {
            builder.field((String)name);
            builder.location(JsonpDeserializer.jsonValueDeserializer().deserialize((JsonParser)parser, (JsonpMapper)mapper));
        });
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements ObjectBuilder<GeoDistanceQuery> {
        private String field;
        private JsonValue location;
        @Nullable
        private String distance;
        @Nullable
        private GeoDistanceType distanceType;
        @Nullable
        private GeoValidationMethod validationMethod;

        public Builder field(String value) {
            this.field = value;
            return this;
        }

        public Builder location(JsonValue value) {
            this.location = value;
            return this;
        }

        public Builder distance(@Nullable String value) {
            this.distance = value;
            return this;
        }

        public Builder distanceType(@Nullable GeoDistanceType value) {
            this.distanceType = value;
            return this;
        }

        public Builder validationMethod(@Nullable GeoValidationMethod value) {
            this.validationMethod = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GeoDistanceQuery build() {
            return new GeoDistanceQuery(this);
        }
    }
}

