/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.query_dsl;

import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryBase;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class BoolQuery
extends QueryBase
implements QueryVariant {
    @Nullable
    private final List<Query> filter;
    @Nullable
    private final String minimumShouldMatch;
    @Nullable
    private final List<Query> must;
    @Nullable
    private final List<Query> mustNot;
    @Nullable
    private final List<Query> should;
    public static final JsonpDeserializer<BoolQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, BoolQuery::setupBoolQueryDeserializer, Builder::build);

    public BoolQuery(Builder builder) {
        super(builder);
        this.filter = ModelTypeHelper.unmodifiable(builder.filter);
        this.minimumShouldMatch = builder.minimumShouldMatch;
        this.must = ModelTypeHelper.unmodifiable(builder.must);
        this.mustNot = ModelTypeHelper.unmodifiable(builder.mustNot);
        this.should = ModelTypeHelper.unmodifiable(builder.should);
    }

    public BoolQuery(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "bool";
    }

    @Nullable
    public List<Query> filter() {
        return this.filter;
    }

    @Nullable
    public String minimumShouldMatch() {
        return this.minimumShouldMatch;
    }

    @Nullable
    public List<Query> must() {
        return this.must;
    }

    @Nullable
    public List<Query> mustNot() {
        return this.mustNot;
    }

    @Nullable
    public List<Query> should() {
        return this.should;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.filter != null) {
            generator.writeKey("filter");
            generator.writeStartArray();
            for (Query item0 : this.filter) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.minimumShouldMatch != null) {
            generator.writeKey("minimum_should_match");
            generator.write(this.minimumShouldMatch);
        }
        if (this.must != null) {
            generator.writeKey("must");
            generator.writeStartArray();
            for (Query item0 : this.must) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.mustNot != null) {
            generator.writeKey("must_not");
            generator.writeStartArray();
            for (Query item0 : this.mustNot) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.should != null) {
            generator.writeKey("should");
            generator.writeStartArray();
            for (Query item0 : this.should) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupBoolQueryDeserializer(DelegatingDeserializer<Builder> op) {
        QueryBase.setupQueryBaseDeserializer(op);
        op.add(Builder::filter, JsonpDeserializer.arrayDeserializer(Query._DESERIALIZER), "filter", new String[0]);
        op.add(Builder::minimumShouldMatch, JsonpDeserializer.stringDeserializer(), "minimum_should_match", new String[0]);
        op.add(Builder::must, JsonpDeserializer.arrayDeserializer(Query._DESERIALIZER), "must", new String[0]);
        op.add(Builder::mustNot, JsonpDeserializer.arrayDeserializer(Query._DESERIALIZER), "must_not", new String[0]);
        op.add(Builder::should, JsonpDeserializer.arrayDeserializer(Query._DESERIALIZER), "should", new String[0]);
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements ObjectBuilder<BoolQuery> {
        @Nullable
        private List<Query> filter;
        @Nullable
        private String minimumShouldMatch;
        @Nullable
        private List<Query> must;
        @Nullable
        private List<Query> mustNot;
        @Nullable
        private List<Query> should;

        public Builder filter(@Nullable List<Query> value) {
            this.filter = value;
            return this;
        }

        public Builder filter(Query ... value) {
            this.filter = Arrays.asList(value);
            return this;
        }

        public Builder addFilter(Query value) {
            if (this.filter == null) {
                this.filter = new ArrayList<Query>();
            }
            this.filter.add(value);
            return this;
        }

        public Builder filter(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.filter(fn.apply(new Query.Builder()).build());
        }

        public Builder addFilter(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.addFilter(fn.apply(new Query.Builder()).build());
        }

        public Builder minimumShouldMatch(@Nullable String value) {
            this.minimumShouldMatch = value;
            return this;
        }

        public Builder must(@Nullable List<Query> value) {
            this.must = value;
            return this;
        }

        public Builder must(Query ... value) {
            this.must = Arrays.asList(value);
            return this;
        }

        public Builder addMust(Query value) {
            if (this.must == null) {
                this.must = new ArrayList<Query>();
            }
            this.must.add(value);
            return this;
        }

        public Builder must(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.must(fn.apply(new Query.Builder()).build());
        }

        public Builder addMust(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.addMust(fn.apply(new Query.Builder()).build());
        }

        public Builder mustNot(@Nullable List<Query> value) {
            this.mustNot = value;
            return this;
        }

        public Builder mustNot(Query ... value) {
            this.mustNot = Arrays.asList(value);
            return this;
        }

        public Builder addMustNot(Query value) {
            if (this.mustNot == null) {
                this.mustNot = new ArrayList<Query>();
            }
            this.mustNot.add(value);
            return this;
        }

        public Builder mustNot(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.mustNot(fn.apply(new Query.Builder()).build());
        }

        public Builder addMustNot(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.addMustNot(fn.apply(new Query.Builder()).build());
        }

        public Builder should(@Nullable List<Query> value) {
            this.should = value;
            return this;
        }

        public Builder should(Query ... value) {
            this.should = Arrays.asList(value);
            return this;
        }

        public Builder addShould(Query value) {
            if (this.should == null) {
                this.should = new ArrayList<Query>();
            }
            this.should.add(value);
            return this;
        }

        public Builder should(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.should(fn.apply(new Query.Builder()).build());
        }

        public Builder addShould(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.addShould(fn.apply(new Query.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public BoolQuery build() {
            return new BoolQuery(this);
        }
    }
}

