/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.mapping;

import co.elastic.clients.elasticsearch._types.mapping.AllField;
import co.elastic.clients.elasticsearch._types.mapping.DynamicTemplate;
import co.elastic.clients.elasticsearch._types.mapping.FieldNamesField;
import co.elastic.clients.elasticsearch._types.mapping.IndexField;
import co.elastic.clients.elasticsearch._types.mapping.Property;
import co.elastic.clients.elasticsearch._types.mapping.RoutingField;
import co.elastic.clients.elasticsearch._types.mapping.RuntimeField;
import co.elastic.clients.elasticsearch._types.mapping.SizeField;
import co.elastic.clients.elasticsearch._types.mapping.SourceField;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class TypeMapping
implements JsonpSerializable {
    @Nullable
    private final AllField allField;
    @Nullable
    private final Boolean dateDetection;
    @Nullable
    private final JsonValue dynamic;
    @Nullable
    private final List<String> dynamicDateFormats;
    @Nullable
    private final List<Map<String, DynamicTemplate>> dynamicTemplates;
    @Nullable
    private final FieldNamesField fieldNames;
    @Nullable
    private final IndexField indexField;
    @Nullable
    private final Map<String, JsonData> meta;
    @Nullable
    private final Boolean numericDetection;
    @Nullable
    private final Map<String, Property> properties;
    @Nullable
    private final RoutingField routing;
    @Nullable
    private final SizeField size;
    @Nullable
    private final SourceField source;
    @Nullable
    private final Map<String, RuntimeField> runtime;
    public static final JsonpDeserializer<TypeMapping> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TypeMapping::setupTypeMappingDeserializer, Builder::build);

    public TypeMapping(Builder builder) {
        this.allField = builder.allField;
        this.dateDetection = builder.dateDetection;
        this.dynamic = builder.dynamic;
        this.dynamicDateFormats = ModelTypeHelper.unmodifiable(builder.dynamicDateFormats);
        this.dynamicTemplates = ModelTypeHelper.unmodifiable(builder.dynamicTemplates);
        this.fieldNames = builder.fieldNames;
        this.indexField = builder.indexField;
        this.meta = ModelTypeHelper.unmodifiable(builder.meta);
        this.numericDetection = builder.numericDetection;
        this.properties = ModelTypeHelper.unmodifiable(builder.properties);
        this.routing = builder.routing;
        this.size = builder.size;
        this.source = builder.source;
        this.runtime = ModelTypeHelper.unmodifiable(builder.runtime);
    }

    public TypeMapping(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public AllField allField() {
        return this.allField;
    }

    @Nullable
    public Boolean dateDetection() {
        return this.dateDetection;
    }

    @Nullable
    public JsonValue dynamic() {
        return this.dynamic;
    }

    @Nullable
    public List<String> dynamicDateFormats() {
        return this.dynamicDateFormats;
    }

    @Nullable
    public List<Map<String, DynamicTemplate>> dynamicTemplates() {
        return this.dynamicTemplates;
    }

    @Nullable
    public FieldNamesField fieldNames() {
        return this.fieldNames;
    }

    @Nullable
    public IndexField indexField() {
        return this.indexField;
    }

    @Nullable
    public Map<String, JsonData> meta() {
        return this.meta;
    }

    @Nullable
    public Boolean numericDetection() {
        return this.numericDetection;
    }

    @Nullable
    public Map<String, Property> properties() {
        return this.properties;
    }

    @Nullable
    public RoutingField routing() {
        return this.routing;
    }

    @Nullable
    public SizeField size() {
        return this.size;
    }

    @Nullable
    public SourceField source() {
        return this.source;
    }

    @Nullable
    public Map<String, RuntimeField> runtime() {
        return this.runtime;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.allField != null) {
            generator.writeKey("all_field");
            this.allField.serialize(generator, mapper);
        }
        if (this.dateDetection != null) {
            generator.writeKey("date_detection");
            generator.write(this.dateDetection.booleanValue());
        }
        if (this.dynamic != null) {
            generator.writeKey("dynamic");
            generator.write(this.dynamic);
        }
        if (this.dynamicDateFormats != null) {
            generator.writeKey("dynamic_date_formats");
            generator.writeStartArray();
            for (String string : this.dynamicDateFormats) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (this.dynamicTemplates != null) {
            generator.writeKey("dynamic_templates");
            generator.writeStartArray();
            for (Map map : this.dynamicTemplates) {
                generator.writeStartObject();
                for (Map.Entry item1 : map.entrySet()) {
                    generator.writeKey((String)item1.getKey());
                    ((DynamicTemplate)item1.getValue()).serialize(generator, mapper);
                }
                generator.writeEnd();
            }
            generator.writeEnd();
        }
        if (this.fieldNames != null) {
            generator.writeKey("_field_names");
            this.fieldNames.serialize(generator, mapper);
        }
        if (this.indexField != null) {
            generator.writeKey("index_field");
            this.indexField.serialize(generator, mapper);
        }
        if (this.meta != null) {
            generator.writeKey("_meta");
            generator.writeStartObject();
            for (Map.Entry entry : this.meta.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((JsonData)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.numericDetection != null) {
            generator.writeKey("numeric_detection");
            generator.write(this.numericDetection.booleanValue());
        }
        if (this.properties != null) {
            generator.writeKey("properties");
            generator.writeStartObject();
            for (Map.Entry entry : this.properties.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((Property)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.routing != null) {
            generator.writeKey("_routing");
            this.routing.serialize(generator, mapper);
        }
        if (this.size != null) {
            generator.writeKey("_size");
            this.size.serialize(generator, mapper);
        }
        if (this.source != null) {
            generator.writeKey("_source");
            this.source.serialize(generator, mapper);
        }
        if (this.runtime != null) {
            generator.writeKey("runtime");
            generator.writeStartObject();
            for (Map.Entry entry : this.runtime.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((RuntimeField)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupTypeMappingDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::allField, AllField._DESERIALIZER, "all_field", new String[0]);
        op.add(Builder::dateDetection, JsonpDeserializer.booleanDeserializer(), "date_detection", new String[0]);
        op.add(Builder::dynamic, JsonpDeserializer.jsonValueDeserializer(), "dynamic", new String[0]);
        op.add(Builder::dynamicDateFormats, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "dynamic_date_formats", new String[0]);
        op.add(Builder::dynamicTemplates, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringMapDeserializer(DynamicTemplate._DESERIALIZER)), "dynamic_templates", new String[0]);
        op.add(Builder::fieldNames, FieldNamesField._DESERIALIZER, "_field_names", new String[0]);
        op.add(Builder::indexField, IndexField._DESERIALIZER, "index_field", new String[0]);
        op.add(Builder::meta, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "_meta", new String[0]);
        op.add(Builder::numericDetection, JsonpDeserializer.booleanDeserializer(), "numeric_detection", new String[0]);
        op.add(Builder::properties, JsonpDeserializer.stringMapDeserializer(Property._DESERIALIZER), "properties", new String[0]);
        op.add(Builder::routing, RoutingField._DESERIALIZER, "_routing", new String[0]);
        op.add(Builder::size, SizeField._DESERIALIZER, "_size", new String[0]);
        op.add(Builder::source, SourceField._DESERIALIZER, "_source", new String[0]);
        op.add(Builder::runtime, JsonpDeserializer.stringMapDeserializer(RuntimeField._DESERIALIZER), "runtime", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<TypeMapping> {
        @Nullable
        private AllField allField;
        @Nullable
        private Boolean dateDetection;
        @Nullable
        private JsonValue dynamic;
        @Nullable
        private List<String> dynamicDateFormats;
        @Nullable
        private List<Map<String, DynamicTemplate>> dynamicTemplates;
        @Nullable
        private FieldNamesField fieldNames;
        @Nullable
        private IndexField indexField;
        @Nullable
        private Map<String, JsonData> meta;
        @Nullable
        private Boolean numericDetection;
        @Nullable
        private Map<String, Property> properties;
        @Nullable
        private RoutingField routing;
        @Nullable
        private SizeField size;
        @Nullable
        private SourceField source;
        @Nullable
        private Map<String, RuntimeField> runtime;

        public Builder allField(@Nullable AllField value) {
            this.allField = value;
            return this;
        }

        public Builder allField(Function<AllField.Builder, ObjectBuilder<AllField>> fn) {
            return this.allField(fn.apply(new AllField.Builder()).build());
        }

        public Builder dateDetection(@Nullable Boolean value) {
            this.dateDetection = value;
            return this;
        }

        public Builder dynamic(@Nullable JsonValue value) {
            this.dynamic = value;
            return this;
        }

        public Builder dynamicDateFormats(@Nullable List<String> value) {
            this.dynamicDateFormats = value;
            return this;
        }

        public Builder dynamicDateFormats(String ... value) {
            this.dynamicDateFormats = Arrays.asList(value);
            return this;
        }

        public Builder addDynamicDateFormats(String value) {
            if (this.dynamicDateFormats == null) {
                this.dynamicDateFormats = new ArrayList<String>();
            }
            this.dynamicDateFormats.add(value);
            return this;
        }

        public Builder dynamicTemplates(@Nullable List<Map<String, DynamicTemplate>> value) {
            this.dynamicTemplates = value;
            return this;
        }

        public Builder dynamicTemplates(Map<String, DynamicTemplate> ... value) {
            this.dynamicTemplates = Arrays.asList(value);
            return this;
        }

        public Builder addDynamicTemplates(Map<String, DynamicTemplate> value) {
            if (this.dynamicTemplates == null) {
                this.dynamicTemplates = new ArrayList<Map<String, DynamicTemplate>>();
            }
            this.dynamicTemplates.add(value);
            return this;
        }

        public Builder fieldNames(@Nullable FieldNamesField value) {
            this.fieldNames = value;
            return this;
        }

        public Builder fieldNames(Function<FieldNamesField.Builder, ObjectBuilder<FieldNamesField>> fn) {
            return this.fieldNames(fn.apply(new FieldNamesField.Builder()).build());
        }

        public Builder indexField(@Nullable IndexField value) {
            this.indexField = value;
            return this;
        }

        public Builder indexField(Function<IndexField.Builder, ObjectBuilder<IndexField>> fn) {
            return this.indexField(fn.apply(new IndexField.Builder()).build());
        }

        public Builder meta(@Nullable Map<String, JsonData> value) {
            this.meta = value;
            return this;
        }

        public Builder putMeta(String key, JsonData value) {
            if (this.meta == null) {
                this.meta = new HashMap<String, JsonData>();
            }
            this.meta.put(key, value);
            return this;
        }

        public Builder numericDetection(@Nullable Boolean value) {
            this.numericDetection = value;
            return this;
        }

        public Builder properties(@Nullable Map<String, Property> value) {
            this.properties = value;
            return this;
        }

        public Builder putProperties(String key, Property value) {
            if (this.properties == null) {
                this.properties = new HashMap<String, Property>();
            }
            this.properties.put(key, value);
            return this;
        }

        public Builder properties(String key, Function<Property.Builder, ObjectBuilder<Property>> fn) {
            return this.properties(Collections.singletonMap(key, fn.apply(new Property.Builder()).build()));
        }

        public Builder putProperties(String key, Function<Property.Builder, ObjectBuilder<Property>> fn) {
            return this.putProperties(key, fn.apply(new Property.Builder()).build());
        }

        public Builder routing(@Nullable RoutingField value) {
            this.routing = value;
            return this;
        }

        public Builder routing(Function<RoutingField.Builder, ObjectBuilder<RoutingField>> fn) {
            return this.routing(fn.apply(new RoutingField.Builder()).build());
        }

        public Builder size(@Nullable SizeField value) {
            this.size = value;
            return this;
        }

        public Builder size(Function<SizeField.Builder, ObjectBuilder<SizeField>> fn) {
            return this.size(fn.apply(new SizeField.Builder()).build());
        }

        public Builder source(@Nullable SourceField value) {
            this.source = value;
            return this;
        }

        public Builder source(Function<SourceField.Builder, ObjectBuilder<SourceField>> fn) {
            return this.source(fn.apply(new SourceField.Builder()).build());
        }

        public Builder runtime(@Nullable Map<String, RuntimeField> value) {
            this.runtime = value;
            return this;
        }

        public Builder putRuntime(String key, RuntimeField value) {
            if (this.runtime == null) {
                this.runtime = new HashMap<String, RuntimeField>();
            }
            this.runtime.put(key, value);
            return this;
        }

        public Builder runtime(String key, Function<RuntimeField.Builder, ObjectBuilder<RuntimeField>> fn) {
            return this.runtime(Collections.singletonMap(key, fn.apply(new RuntimeField.Builder()).build()));
        }

        public Builder putRuntime(String key, Function<RuntimeField.Builder, ObjectBuilder<RuntimeField>> fn) {
            return this.putRuntime(key, fn.apply(new RuntimeField.Builder()).build());
        }

        @Override
        public TypeMapping build() {
            return new TypeMapping(this);
        }
    }
}

