/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.mapping;

import co.elastic.clients.elasticsearch._types.mapping.PropertyBase;
import co.elastic.clients.elasticsearch._types.mapping.PropertyVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class AggregateMetricDoubleProperty
extends PropertyBase
implements PropertyVariant {
    private final String defaultMetric;
    private final List<String> metrics;
    public static final JsonpDeserializer<AggregateMetricDoubleProperty> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, AggregateMetricDoubleProperty::setupAggregateMetricDoublePropertyDeserializer, Builder::build);

    public AggregateMetricDoubleProperty(Builder builder) {
        super(builder);
        this.defaultMetric = Objects.requireNonNull(builder.defaultMetric, "default_metric");
        this.metrics = ModelTypeHelper.unmodifiableNonNull(builder.metrics, "metrics");
    }

    public AggregateMetricDoubleProperty(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "aggregate_metric_double";
    }

    public String defaultMetric() {
        return this.defaultMetric;
    }

    public List<String> metrics() {
        return this.metrics;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "aggregate_metric_double");
        super.serializeInternal(generator, mapper);
        generator.writeKey("default_metric");
        generator.write(this.defaultMetric);
        generator.writeKey("metrics");
        generator.writeStartArray();
        for (String item0 : this.metrics) {
            generator.write(item0);
        }
        generator.writeEnd();
    }

    protected static void setupAggregateMetricDoublePropertyDeserializer(DelegatingDeserializer<Builder> op) {
        PropertyBase.setupPropertyBaseDeserializer(op);
        op.add(Builder::defaultMetric, JsonpDeserializer.stringDeserializer(), "default_metric", new String[0]);
        op.add(Builder::metrics, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "metrics", new String[0]);
        op.ignore("type");
    }

    public static class Builder
    extends PropertyBase.AbstractBuilder<Builder>
    implements ObjectBuilder<AggregateMetricDoubleProperty> {
        private String defaultMetric;
        private List<String> metrics;

        public Builder defaultMetric(String value) {
            this.defaultMetric = value;
            return this;
        }

        public Builder metrics(List<String> value) {
            this.metrics = value;
            return this;
        }

        public Builder metrics(String ... value) {
            this.metrics = Arrays.asList(value);
            return this;
        }

        public Builder addMetrics(String value) {
            if (this.metrics == null) {
                this.metrics = new ArrayList<String>();
            }
            this.metrics.add(value);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public AggregateMetricDoubleProperty build() {
            return new AggregateMetricDoubleProperty(this);
        }
    }
}

