/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.analysis;

import co.elastic.clients.elasticsearch._types.analysis.TokenFilterBase;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilterVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class MultiplexerTokenFilter
extends TokenFilterBase
implements TokenFilterVariant {
    private final List<String> filters;
    private final boolean preserveOriginal;
    public static final JsonpDeserializer<MultiplexerTokenFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, MultiplexerTokenFilter::setupMultiplexerTokenFilterDeserializer, Builder::build);

    public MultiplexerTokenFilter(Builder builder) {
        super(builder);
        this.filters = ModelTypeHelper.unmodifiableNonNull(builder.filters, "filters");
        this.preserveOriginal = Objects.requireNonNull(builder.preserveOriginal, "preserve_original");
    }

    public MultiplexerTokenFilter(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "multiplexer";
    }

    public List<String> filters() {
        return this.filters;
    }

    public boolean preserveOriginal() {
        return this.preserveOriginal;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "multiplexer");
        super.serializeInternal(generator, mapper);
        generator.writeKey("filters");
        generator.writeStartArray();
        for (String item0 : this.filters) {
            generator.write(item0);
        }
        generator.writeEnd();
        generator.writeKey("preserve_original");
        generator.write(this.preserveOriginal);
    }

    protected static void setupMultiplexerTokenFilterDeserializer(DelegatingDeserializer<Builder> op) {
        TokenFilterBase.setupTokenFilterBaseDeserializer(op);
        op.add(Builder::filters, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "filters", new String[0]);
        op.add(Builder::preserveOriginal, JsonpDeserializer.booleanDeserializer(), "preserve_original", new String[0]);
        op.ignore("type");
    }

    public static class Builder
    extends TokenFilterBase.AbstractBuilder<Builder>
    implements ObjectBuilder<MultiplexerTokenFilter> {
        private List<String> filters;
        private Boolean preserveOriginal;

        public Builder filters(List<String> value) {
            this.filters = value;
            return this;
        }

        public Builder filters(String ... value) {
            this.filters = Arrays.asList(value);
            return this;
        }

        public Builder addFilters(String value) {
            if (this.filters == null) {
                this.filters = new ArrayList<String>();
            }
            this.filters.add(value);
            return this;
        }

        public Builder preserveOriginal(boolean value) {
            this.preserveOriginal = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public MultiplexerTokenFilter build() {
            return new MultiplexerTokenFilter(this);
        }
    }
}

