/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.analysis;

import co.elastic.clients.elasticsearch._types.analysis.AnalyzerVariant;
import co.elastic.clients.elasticsearch._types.analysis.KuromojiTokenizationMode;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class KuromojiAnalyzer
implements AnalyzerVariant,
JsonpSerializable {
    private final KuromojiTokenizationMode mode;
    private final String userDictionary;
    public static final JsonpDeserializer<KuromojiAnalyzer> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, KuromojiAnalyzer::setupKuromojiAnalyzerDeserializer, Builder::build);

    public KuromojiAnalyzer(Builder builder) {
        this.mode = Objects.requireNonNull(builder.mode, "mode");
        this.userDictionary = Objects.requireNonNull(builder.userDictionary, "user_dictionary");
    }

    public KuromojiAnalyzer(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "kuromoji";
    }

    public KuromojiTokenizationMode mode() {
        return this.mode;
    }

    public String userDictionary() {
        return this.userDictionary;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "kuromoji");
        generator.writeKey("mode");
        this.mode.serialize(generator, mapper);
        generator.writeKey("user_dictionary");
        generator.write(this.userDictionary);
    }

    protected static void setupKuromojiAnalyzerDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::mode, KuromojiTokenizationMode._DESERIALIZER, "mode", new String[0]);
        op.add(Builder::userDictionary, JsonpDeserializer.stringDeserializer(), "user_dictionary", new String[0]);
        op.ignore("type");
    }

    public static class Builder
    implements ObjectBuilder<KuromojiAnalyzer> {
        private KuromojiTokenizationMode mode;
        private String userDictionary;

        public Builder mode(KuromojiTokenizationMode value) {
            this.mode = value;
            return this;
        }

        public Builder userDictionary(String value) {
            this.userDictionary = value;
            return this;
        }

        @Override
        public KuromojiAnalyzer build() {
            return new KuromojiAnalyzer(this);
        }
    }
}

