/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.analysis;

import co.elastic.clients.elasticsearch._types.analysis.TokenizerBase;
import co.elastic.clients.elasticsearch._types.analysis.TokenizerVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class KeywordTokenizer
extends TokenizerBase
implements TokenizerVariant {
    private final int bufferSize;
    public static final JsonpDeserializer<KeywordTokenizer> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, KeywordTokenizer::setupKeywordTokenizerDeserializer, Builder::build);

    public KeywordTokenizer(Builder builder) {
        super(builder);
        this.bufferSize = Objects.requireNonNull(builder.bufferSize, "buffer_size");
    }

    public KeywordTokenizer(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "keyword";
    }

    public int bufferSize() {
        return this.bufferSize;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "keyword");
        super.serializeInternal(generator, mapper);
        generator.writeKey("buffer_size");
        generator.write(this.bufferSize);
    }

    protected static void setupKeywordTokenizerDeserializer(DelegatingDeserializer<Builder> op) {
        TokenizerBase.setupTokenizerBaseDeserializer(op);
        op.add(Builder::bufferSize, JsonpDeserializer.integerDeserializer(), "buffer_size", new String[0]);
        op.ignore("type");
    }

    public static class Builder
    extends TokenizerBase.AbstractBuilder<Builder>
    implements ObjectBuilder<KeywordTokenizer> {
        private Integer bufferSize;

        public Builder bufferSize(int value) {
            this.bufferSize = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public KeywordTokenizer build() {
            return new KeywordTokenizer(this);
        }
    }
}

