/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.analysis;

import co.elastic.clients.elasticsearch._types.analysis.TokenFilterBase;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilterVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class ConditionTokenFilter
extends TokenFilterBase
implements TokenFilterVariant {
    private final List<String> filter;
    private final JsonValue script;
    public static final JsonpDeserializer<ConditionTokenFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ConditionTokenFilter::setupConditionTokenFilterDeserializer, Builder::build);

    public ConditionTokenFilter(Builder builder) {
        super(builder);
        this.filter = ModelTypeHelper.unmodifiableNonNull(builder.filter, "filter");
        this.script = Objects.requireNonNull(builder.script, "script");
    }

    public ConditionTokenFilter(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "condition";
    }

    public List<String> filter() {
        return this.filter;
    }

    public JsonValue script() {
        return this.script;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "condition");
        super.serializeInternal(generator, mapper);
        generator.writeKey("filter");
        generator.writeStartArray();
        for (String item0 : this.filter) {
            generator.write(item0);
        }
        generator.writeEnd();
        generator.writeKey("script");
        generator.write(this.script);
    }

    protected static void setupConditionTokenFilterDeserializer(DelegatingDeserializer<Builder> op) {
        TokenFilterBase.setupTokenFilterBaseDeserializer(op);
        op.add(Builder::filter, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "filter", new String[0]);
        op.add(Builder::script, JsonpDeserializer.jsonValueDeserializer(), "script", new String[0]);
        op.ignore("type");
    }

    public static class Builder
    extends TokenFilterBase.AbstractBuilder<Builder>
    implements ObjectBuilder<ConditionTokenFilter> {
        private List<String> filter;
        private JsonValue script;

        public Builder filter(List<String> value) {
            this.filter = value;
            return this;
        }

        public Builder filter(String ... value) {
            this.filter = Arrays.asList(value);
            return this;
        }

        public Builder addFilter(String value) {
            if (this.filter == null) {
                this.filter = new ArrayList<String>();
            }
            this.filter.add(value);
            return this;
        }

        public Builder script(JsonValue value) {
            this.script = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ConditionTokenFilter build() {
            return new ConditionTokenFilter(this);
        }
    }
}

