/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._core.search.Highlight;
import co.elastic.clients.elasticsearch._types.ScriptField;
import co.elastic.clients.elasticsearch._types.aggregations.AggregationVariant;
import co.elastic.clients.elasticsearch._types.aggregations.MetricAggregationBase;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class TopHitsAggregation
extends MetricAggregationBase
implements AggregationVariant {
    @Nullable
    private final List<String> docvalueFields;
    @Nullable
    private final Boolean explain;
    @Nullable
    private final Integer from;
    @Nullable
    private final Highlight highlight;
    @Nullable
    private final Map<String, ScriptField> scriptFields;
    @Nullable
    private final Integer size;
    @Nullable
    private final List<JsonValue> sort;
    @Nullable
    private final JsonValue source;
    @Nullable
    private final List<String> storedFields;
    @Nullable
    private final Boolean trackScores;
    @Nullable
    private final Boolean version;
    @Nullable
    private final Boolean seqNoPrimaryTerm;
    public static final JsonpDeserializer<TopHitsAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TopHitsAggregation::setupTopHitsAggregationDeserializer, Builder::build);

    public TopHitsAggregation(Builder builder) {
        super(builder);
        this.docvalueFields = ModelTypeHelper.unmodifiable(builder.docvalueFields);
        this.explain = builder.explain;
        this.from = builder.from;
        this.highlight = builder.highlight;
        this.scriptFields = ModelTypeHelper.unmodifiable(builder.scriptFields);
        this.size = builder.size;
        this.sort = ModelTypeHelper.unmodifiable(builder.sort);
        this.source = builder.source;
        this.storedFields = ModelTypeHelper.unmodifiable(builder.storedFields);
        this.trackScores = builder.trackScores;
        this.version = builder.version;
        this.seqNoPrimaryTerm = builder.seqNoPrimaryTerm;
    }

    public TopHitsAggregation(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "top_hits";
    }

    @Nullable
    public List<String> docvalueFields() {
        return this.docvalueFields;
    }

    @Nullable
    public Boolean explain() {
        return this.explain;
    }

    @Nullable
    public Integer from() {
        return this.from;
    }

    @Nullable
    public Highlight highlight() {
        return this.highlight;
    }

    @Nullable
    public Map<String, ScriptField> scriptFields() {
        return this.scriptFields;
    }

    @Nullable
    public Integer size() {
        return this.size;
    }

    @Nullable
    public List<JsonValue> sort() {
        return this.sort;
    }

    @Nullable
    public JsonValue source() {
        return this.source;
    }

    @Nullable
    public List<String> storedFields() {
        return this.storedFields;
    }

    @Nullable
    public Boolean trackScores() {
        return this.trackScores;
    }

    @Nullable
    public Boolean version() {
        return this.version;
    }

    @Nullable
    public Boolean seqNoPrimaryTerm() {
        return this.seqNoPrimaryTerm;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.docvalueFields != null) {
            generator.writeKey("docvalue_fields");
            generator.writeStartArray();
            for (String string : this.docvalueFields) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (this.explain != null) {
            generator.writeKey("explain");
            generator.write(this.explain.booleanValue());
        }
        if (this.from != null) {
            generator.writeKey("from");
            generator.write(this.from.intValue());
        }
        if (this.highlight != null) {
            generator.writeKey("highlight");
            this.highlight.serialize(generator, mapper);
        }
        if (this.scriptFields != null) {
            generator.writeKey("script_fields");
            generator.writeStartObject();
            for (Map.Entry entry : this.scriptFields.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((ScriptField)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.size != null) {
            generator.writeKey("size");
            generator.write(this.size.intValue());
        }
        if (this.sort != null) {
            generator.writeKey("sort");
            generator.writeStartArray();
            for (JsonValue jsonValue : this.sort) {
                generator.write(jsonValue);
            }
            generator.writeEnd();
        }
        if (this.source != null) {
            generator.writeKey("_source");
            generator.write(this.source);
        }
        if (this.storedFields != null) {
            generator.writeKey("stored_fields");
            generator.writeStartArray();
            for (String string : this.storedFields) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (this.trackScores != null) {
            generator.writeKey("track_scores");
            generator.write(this.trackScores.booleanValue());
        }
        if (this.version != null) {
            generator.writeKey("version");
            generator.write(this.version.booleanValue());
        }
        if (this.seqNoPrimaryTerm != null) {
            generator.writeKey("seq_no_primary_term");
            generator.write(this.seqNoPrimaryTerm.booleanValue());
        }
    }

    protected static void setupTopHitsAggregationDeserializer(DelegatingDeserializer<Builder> op) {
        MetricAggregationBase.setupMetricAggregationBaseDeserializer(op);
        op.add(Builder::docvalueFields, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "docvalue_fields", new String[0]);
        op.add(Builder::explain, JsonpDeserializer.booleanDeserializer(), "explain", new String[0]);
        op.add(Builder::from, JsonpDeserializer.integerDeserializer(), "from", new String[0]);
        op.add(Builder::highlight, Highlight._DESERIALIZER, "highlight", new String[0]);
        op.add(Builder::scriptFields, JsonpDeserializer.stringMapDeserializer(ScriptField._DESERIALIZER), "script_fields", new String[0]);
        op.add(Builder::size, JsonpDeserializer.integerDeserializer(), "size", new String[0]);
        op.add(Builder::sort, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.jsonValueDeserializer()), "sort", new String[0]);
        op.add(Builder::source, JsonpDeserializer.jsonValueDeserializer(), "_source", new String[0]);
        op.add(Builder::storedFields, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "stored_fields", new String[0]);
        op.add(Builder::trackScores, JsonpDeserializer.booleanDeserializer(), "track_scores", new String[0]);
        op.add(Builder::version, JsonpDeserializer.booleanDeserializer(), "version", new String[0]);
        op.add(Builder::seqNoPrimaryTerm, JsonpDeserializer.booleanDeserializer(), "seq_no_primary_term", new String[0]);
    }

    public static class Builder
    extends MetricAggregationBase.AbstractBuilder<Builder>
    implements ObjectBuilder<TopHitsAggregation> {
        @Nullable
        private List<String> docvalueFields;
        @Nullable
        private Boolean explain;
        @Nullable
        private Integer from;
        @Nullable
        private Highlight highlight;
        @Nullable
        private Map<String, ScriptField> scriptFields;
        @Nullable
        private Integer size;
        @Nullable
        private List<JsonValue> sort;
        @Nullable
        private JsonValue source;
        @Nullable
        private List<String> storedFields;
        @Nullable
        private Boolean trackScores;
        @Nullable
        private Boolean version;
        @Nullable
        private Boolean seqNoPrimaryTerm;

        public Builder docvalueFields(@Nullable List<String> value) {
            this.docvalueFields = value;
            return this;
        }

        public Builder docvalueFields(String ... value) {
            this.docvalueFields = Arrays.asList(value);
            return this;
        }

        public Builder addDocvalueFields(String value) {
            if (this.docvalueFields == null) {
                this.docvalueFields = new ArrayList<String>();
            }
            this.docvalueFields.add(value);
            return this;
        }

        public Builder explain(@Nullable Boolean value) {
            this.explain = value;
            return this;
        }

        public Builder from(@Nullable Integer value) {
            this.from = value;
            return this;
        }

        public Builder highlight(@Nullable Highlight value) {
            this.highlight = value;
            return this;
        }

        public Builder highlight(Function<Highlight.Builder, ObjectBuilder<Highlight>> fn) {
            return this.highlight(fn.apply(new Highlight.Builder()).build());
        }

        public Builder scriptFields(@Nullable Map<String, ScriptField> value) {
            this.scriptFields = value;
            return this;
        }

        public Builder putScriptFields(String key, ScriptField value) {
            if (this.scriptFields == null) {
                this.scriptFields = new HashMap<String, ScriptField>();
            }
            this.scriptFields.put(key, value);
            return this;
        }

        public Builder scriptFields(String key, Function<ScriptField.Builder, ObjectBuilder<ScriptField>> fn) {
            return this.scriptFields(Collections.singletonMap(key, fn.apply(new ScriptField.Builder()).build()));
        }

        public Builder putScriptFields(String key, Function<ScriptField.Builder, ObjectBuilder<ScriptField>> fn) {
            return this.putScriptFields(key, fn.apply(new ScriptField.Builder()).build());
        }

        public Builder size(@Nullable Integer value) {
            this.size = value;
            return this;
        }

        public Builder sort(@Nullable List<JsonValue> value) {
            this.sort = value;
            return this;
        }

        public Builder sort(JsonValue ... value) {
            this.sort = Arrays.asList(value);
            return this;
        }

        public Builder addSort(JsonValue value) {
            if (this.sort == null) {
                this.sort = new ArrayList<JsonValue>();
            }
            this.sort.add(value);
            return this;
        }

        public Builder source(@Nullable JsonValue value) {
            this.source = value;
            return this;
        }

        public Builder storedFields(@Nullable List<String> value) {
            this.storedFields = value;
            return this;
        }

        public Builder storedFields(String ... value) {
            this.storedFields = Arrays.asList(value);
            return this;
        }

        public Builder addStoredFields(String value) {
            if (this.storedFields == null) {
                this.storedFields = new ArrayList<String>();
            }
            this.storedFields.add(value);
            return this;
        }

        public Builder trackScores(@Nullable Boolean value) {
            this.trackScores = value;
            return this;
        }

        public Builder version(@Nullable Boolean value) {
            this.version = value;
            return this;
        }

        public Builder seqNoPrimaryTerm(@Nullable Boolean value) {
            this.seqNoPrimaryTerm = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public TopHitsAggregation build() {
            return new TopHitsAggregation(this);
        }
    }
}

