/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class GoogleNormalizedDistanceHeuristic
implements JsonpSerializable {
    private final boolean backgroundIsSuperset;
    public static final JsonpDeserializer<GoogleNormalizedDistanceHeuristic> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GoogleNormalizedDistanceHeuristic::setupGoogleNormalizedDistanceHeuristicDeserializer, Builder::build);

    public GoogleNormalizedDistanceHeuristic(Builder builder) {
        this.backgroundIsSuperset = Objects.requireNonNull(builder.backgroundIsSuperset, "background_is_superset");
    }

    public GoogleNormalizedDistanceHeuristic(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public boolean backgroundIsSuperset() {
        return this.backgroundIsSuperset;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("background_is_superset");
        generator.write(this.backgroundIsSuperset);
    }

    protected static void setupGoogleNormalizedDistanceHeuristicDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::backgroundIsSuperset, JsonpDeserializer.booleanDeserializer(), "background_is_superset", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<GoogleNormalizedDistanceHeuristic> {
        private Boolean backgroundIsSuperset;

        public Builder backgroundIsSuperset(boolean value) {
            this.backgroundIsSuperset = value;
            return this;
        }

        @Override
        public GoogleNormalizedDistanceHeuristic build() {
            return new GoogleNormalizedDistanceHeuristic(this);
        }
    }
}

