/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.AggregationVariant;
import co.elastic.clients.elasticsearch._types.aggregations.BucketAggregationBase;
import co.elastic.clients.elasticsearch._types.query_dsl.BoundingBox;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class GeoHashGridAggregation
extends BucketAggregationBase
implements AggregationVariant {
    @Nullable
    private final BoundingBox bounds;
    @Nullable
    private final String field;
    @Nullable
    private final Number precision;
    @Nullable
    private final Integer shardSize;
    @Nullable
    private final Integer size;
    public static final JsonpDeserializer<GeoHashGridAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GeoHashGridAggregation::setupGeoHashGridAggregationDeserializer, Builder::build);

    public GeoHashGridAggregation(Builder builder) {
        super(builder);
        this.bounds = builder.bounds;
        this.field = builder.field;
        this.precision = builder.precision;
        this.shardSize = builder.shardSize;
        this.size = builder.size;
    }

    public GeoHashGridAggregation(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "geohash_grid";
    }

    @Nullable
    public BoundingBox bounds() {
        return this.bounds;
    }

    @Nullable
    public String field() {
        return this.field;
    }

    @Nullable
    public Number precision() {
        return this.precision;
    }

    @Nullable
    public Integer shardSize() {
        return this.shardSize;
    }

    @Nullable
    public Integer size() {
        return this.size;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.bounds != null) {
            generator.writeKey("bounds");
            this.bounds.serialize(generator, mapper);
        }
        if (this.field != null) {
            generator.writeKey("field");
            generator.write(this.field);
        }
        if (this.precision != null) {
            generator.writeKey("precision");
            generator.write(this.precision.doubleValue());
        }
        if (this.shardSize != null) {
            generator.writeKey("shard_size");
            generator.write(this.shardSize.intValue());
        }
        if (this.size != null) {
            generator.writeKey("size");
            generator.write(this.size.intValue());
        }
    }

    protected static void setupGeoHashGridAggregationDeserializer(DelegatingDeserializer<Builder> op) {
        BucketAggregationBase.setupBucketAggregationBaseDeserializer(op);
        op.add(Builder::bounds, BoundingBox._DESERIALIZER, "bounds", new String[0]);
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field", new String[0]);
        op.add(Builder::precision, JsonpDeserializer.numberDeserializer(), "precision", new String[0]);
        op.add(Builder::shardSize, JsonpDeserializer.integerDeserializer(), "shard_size", new String[0]);
        op.add(Builder::size, JsonpDeserializer.integerDeserializer(), "size", new String[0]);
    }

    public static class Builder
    extends BucketAggregationBase.AbstractBuilder<Builder>
    implements ObjectBuilder<GeoHashGridAggregation> {
        @Nullable
        private BoundingBox bounds;
        @Nullable
        private String field;
        @Nullable
        private Number precision;
        @Nullable
        private Integer shardSize;
        @Nullable
        private Integer size;

        public Builder bounds(@Nullable BoundingBox value) {
            this.bounds = value;
            return this;
        }

        public Builder bounds(Function<BoundingBox.Builder, ObjectBuilder<BoundingBox>> fn) {
            return this.bounds(fn.apply(new BoundingBox.Builder()).build());
        }

        public Builder field(@Nullable String value) {
            this.field = value;
            return this;
        }

        public Builder precision(@Nullable Number value) {
            this.precision = value;
            return this;
        }

        public Builder shardSize(@Nullable Integer value) {
            this.shardSize = value;
            return this;
        }

        public Builder size(@Nullable Integer value) {
            this.size = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GeoHashGridAggregation build() {
            return new GeoHashGridAggregation(this);
        }
    }
}

