/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class RequestCacheStats
implements JsonpSerializable {
    private final long evictions;
    private final long hitCount;
    @Nullable
    private final String memorySize;
    private final long memorySizeInBytes;
    private final long missCount;
    public static final JsonpDeserializer<RequestCacheStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RequestCacheStats::setupRequestCacheStatsDeserializer, Builder::build);

    public RequestCacheStats(Builder builder) {
        this.evictions = Objects.requireNonNull(builder.evictions, "evictions");
        this.hitCount = Objects.requireNonNull(builder.hitCount, "hit_count");
        this.memorySize = builder.memorySize;
        this.memorySizeInBytes = Objects.requireNonNull(builder.memorySizeInBytes, "memory_size_in_bytes");
        this.missCount = Objects.requireNonNull(builder.missCount, "miss_count");
    }

    public RequestCacheStats(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public long evictions() {
        return this.evictions;
    }

    public long hitCount() {
        return this.hitCount;
    }

    @Nullable
    public String memorySize() {
        return this.memorySize;
    }

    public long memorySizeInBytes() {
        return this.memorySizeInBytes;
    }

    public long missCount() {
        return this.missCount;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("evictions");
        generator.write(this.evictions);
        generator.writeKey("hit_count");
        generator.write(this.hitCount);
        if (this.memorySize != null) {
            generator.writeKey("memory_size");
            generator.write(this.memorySize);
        }
        generator.writeKey("memory_size_in_bytes");
        generator.write(this.memorySizeInBytes);
        generator.writeKey("miss_count");
        generator.write(this.missCount);
    }

    protected static void setupRequestCacheStatsDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::evictions, JsonpDeserializer.longDeserializer(), "evictions", new String[0]);
        op.add(Builder::hitCount, JsonpDeserializer.longDeserializer(), "hit_count", new String[0]);
        op.add(Builder::memorySize, JsonpDeserializer.stringDeserializer(), "memory_size", new String[0]);
        op.add(Builder::memorySizeInBytes, JsonpDeserializer.longDeserializer(), "memory_size_in_bytes", new String[0]);
        op.add(Builder::missCount, JsonpDeserializer.longDeserializer(), "miss_count", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<RequestCacheStats> {
        private Long evictions;
        private Long hitCount;
        @Nullable
        private String memorySize;
        private Long memorySizeInBytes;
        private Long missCount;

        public Builder evictions(long value) {
            this.evictions = value;
            return this;
        }

        public Builder hitCount(long value) {
            this.hitCount = value;
            return this;
        }

        public Builder memorySize(@Nullable String value) {
            this.memorySize = value;
            return this;
        }

        public Builder memorySizeInBytes(long value) {
            this.memorySizeInBytes = value;
            return this;
        }

        public Builder missCount(long value) {
            this.missCount = value;
            return this;
        }

        @Override
        public RequestCacheStats build() {
            return new RequestCacheStats(this);
        }
    }
}

