/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class MergesStats
implements JsonpSerializable {
    private final long current;
    private final long currentDocs;
    @Nullable
    private final String currentSize;
    private final long currentSizeInBytes;
    private final long total;
    @Nullable
    private final String totalAutoThrottle;
    private final long totalAutoThrottleInBytes;
    private final long totalDocs;
    @Nullable
    private final String totalSize;
    private final long totalSizeInBytes;
    @Nullable
    private final String totalStoppedTime;
    private final long totalStoppedTimeInMillis;
    @Nullable
    private final String totalThrottledTime;
    private final long totalThrottledTimeInMillis;
    @Nullable
    private final String totalTime;
    private final long totalTimeInMillis;
    public static final JsonpDeserializer<MergesStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, MergesStats::setupMergesStatsDeserializer, Builder::build);

    public MergesStats(Builder builder) {
        this.current = Objects.requireNonNull(builder.current, "current");
        this.currentDocs = Objects.requireNonNull(builder.currentDocs, "current_docs");
        this.currentSize = builder.currentSize;
        this.currentSizeInBytes = Objects.requireNonNull(builder.currentSizeInBytes, "current_size_in_bytes");
        this.total = Objects.requireNonNull(builder.total, "total");
        this.totalAutoThrottle = builder.totalAutoThrottle;
        this.totalAutoThrottleInBytes = Objects.requireNonNull(builder.totalAutoThrottleInBytes, "total_auto_throttle_in_bytes");
        this.totalDocs = Objects.requireNonNull(builder.totalDocs, "total_docs");
        this.totalSize = builder.totalSize;
        this.totalSizeInBytes = Objects.requireNonNull(builder.totalSizeInBytes, "total_size_in_bytes");
        this.totalStoppedTime = builder.totalStoppedTime;
        this.totalStoppedTimeInMillis = Objects.requireNonNull(builder.totalStoppedTimeInMillis, "total_stopped_time_in_millis");
        this.totalThrottledTime = builder.totalThrottledTime;
        this.totalThrottledTimeInMillis = Objects.requireNonNull(builder.totalThrottledTimeInMillis, "total_throttled_time_in_millis");
        this.totalTime = builder.totalTime;
        this.totalTimeInMillis = Objects.requireNonNull(builder.totalTimeInMillis, "total_time_in_millis");
    }

    public MergesStats(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public long current() {
        return this.current;
    }

    public long currentDocs() {
        return this.currentDocs;
    }

    @Nullable
    public String currentSize() {
        return this.currentSize;
    }

    public long currentSizeInBytes() {
        return this.currentSizeInBytes;
    }

    public long total() {
        return this.total;
    }

    @Nullable
    public String totalAutoThrottle() {
        return this.totalAutoThrottle;
    }

    public long totalAutoThrottleInBytes() {
        return this.totalAutoThrottleInBytes;
    }

    public long totalDocs() {
        return this.totalDocs;
    }

    @Nullable
    public String totalSize() {
        return this.totalSize;
    }

    public long totalSizeInBytes() {
        return this.totalSizeInBytes;
    }

    @Nullable
    public String totalStoppedTime() {
        return this.totalStoppedTime;
    }

    public long totalStoppedTimeInMillis() {
        return this.totalStoppedTimeInMillis;
    }

    @Nullable
    public String totalThrottledTime() {
        return this.totalThrottledTime;
    }

    public long totalThrottledTimeInMillis() {
        return this.totalThrottledTimeInMillis;
    }

    @Nullable
    public String totalTime() {
        return this.totalTime;
    }

    public long totalTimeInMillis() {
        return this.totalTimeInMillis;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("current");
        generator.write(this.current);
        generator.writeKey("current_docs");
        generator.write(this.currentDocs);
        if (this.currentSize != null) {
            generator.writeKey("current_size");
            generator.write(this.currentSize);
        }
        generator.writeKey("current_size_in_bytes");
        generator.write(this.currentSizeInBytes);
        generator.writeKey("total");
        generator.write(this.total);
        if (this.totalAutoThrottle != null) {
            generator.writeKey("total_auto_throttle");
            generator.write(this.totalAutoThrottle);
        }
        generator.writeKey("total_auto_throttle_in_bytes");
        generator.write(this.totalAutoThrottleInBytes);
        generator.writeKey("total_docs");
        generator.write(this.totalDocs);
        if (this.totalSize != null) {
            generator.writeKey("total_size");
            generator.write(this.totalSize);
        }
        generator.writeKey("total_size_in_bytes");
        generator.write(this.totalSizeInBytes);
        if (this.totalStoppedTime != null) {
            generator.writeKey("total_stopped_time");
            generator.write(this.totalStoppedTime);
        }
        generator.writeKey("total_stopped_time_in_millis");
        generator.write(this.totalStoppedTimeInMillis);
        if (this.totalThrottledTime != null) {
            generator.writeKey("total_throttled_time");
            generator.write(this.totalThrottledTime);
        }
        generator.writeKey("total_throttled_time_in_millis");
        generator.write(this.totalThrottledTimeInMillis);
        if (this.totalTime != null) {
            generator.writeKey("total_time");
            generator.write(this.totalTime);
        }
        generator.writeKey("total_time_in_millis");
        generator.write(this.totalTimeInMillis);
    }

    protected static void setupMergesStatsDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::current, JsonpDeserializer.longDeserializer(), "current", new String[0]);
        op.add(Builder::currentDocs, JsonpDeserializer.longDeserializer(), "current_docs", new String[0]);
        op.add(Builder::currentSize, JsonpDeserializer.stringDeserializer(), "current_size", new String[0]);
        op.add(Builder::currentSizeInBytes, JsonpDeserializer.longDeserializer(), "current_size_in_bytes", new String[0]);
        op.add(Builder::total, JsonpDeserializer.longDeserializer(), "total", new String[0]);
        op.add(Builder::totalAutoThrottle, JsonpDeserializer.stringDeserializer(), "total_auto_throttle", new String[0]);
        op.add(Builder::totalAutoThrottleInBytes, JsonpDeserializer.longDeserializer(), "total_auto_throttle_in_bytes", new String[0]);
        op.add(Builder::totalDocs, JsonpDeserializer.longDeserializer(), "total_docs", new String[0]);
        op.add(Builder::totalSize, JsonpDeserializer.stringDeserializer(), "total_size", new String[0]);
        op.add(Builder::totalSizeInBytes, JsonpDeserializer.longDeserializer(), "total_size_in_bytes", new String[0]);
        op.add(Builder::totalStoppedTime, JsonpDeserializer.stringDeserializer(), "total_stopped_time", new String[0]);
        op.add(Builder::totalStoppedTimeInMillis, JsonpDeserializer.longDeserializer(), "total_stopped_time_in_millis", new String[0]);
        op.add(Builder::totalThrottledTime, JsonpDeserializer.stringDeserializer(), "total_throttled_time", new String[0]);
        op.add(Builder::totalThrottledTimeInMillis, JsonpDeserializer.longDeserializer(), "total_throttled_time_in_millis", new String[0]);
        op.add(Builder::totalTime, JsonpDeserializer.stringDeserializer(), "total_time", new String[0]);
        op.add(Builder::totalTimeInMillis, JsonpDeserializer.longDeserializer(), "total_time_in_millis", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<MergesStats> {
        private Long current;
        private Long currentDocs;
        @Nullable
        private String currentSize;
        private Long currentSizeInBytes;
        private Long total;
        @Nullable
        private String totalAutoThrottle;
        private Long totalAutoThrottleInBytes;
        private Long totalDocs;
        @Nullable
        private String totalSize;
        private Long totalSizeInBytes;
        @Nullable
        private String totalStoppedTime;
        private Long totalStoppedTimeInMillis;
        @Nullable
        private String totalThrottledTime;
        private Long totalThrottledTimeInMillis;
        @Nullable
        private String totalTime;
        private Long totalTimeInMillis;

        public Builder current(long value) {
            this.current = value;
            return this;
        }

        public Builder currentDocs(long value) {
            this.currentDocs = value;
            return this;
        }

        public Builder currentSize(@Nullable String value) {
            this.currentSize = value;
            return this;
        }

        public Builder currentSizeInBytes(long value) {
            this.currentSizeInBytes = value;
            return this;
        }

        public Builder total(long value) {
            this.total = value;
            return this;
        }

        public Builder totalAutoThrottle(@Nullable String value) {
            this.totalAutoThrottle = value;
            return this;
        }

        public Builder totalAutoThrottleInBytes(long value) {
            this.totalAutoThrottleInBytes = value;
            return this;
        }

        public Builder totalDocs(long value) {
            this.totalDocs = value;
            return this;
        }

        public Builder totalSize(@Nullable String value) {
            this.totalSize = value;
            return this;
        }

        public Builder totalSizeInBytes(long value) {
            this.totalSizeInBytes = value;
            return this;
        }

        public Builder totalStoppedTime(@Nullable String value) {
            this.totalStoppedTime = value;
            return this;
        }

        public Builder totalStoppedTimeInMillis(long value) {
            this.totalStoppedTimeInMillis = value;
            return this;
        }

        public Builder totalThrottledTime(@Nullable String value) {
            this.totalThrottledTime = value;
            return this;
        }

        public Builder totalThrottledTimeInMillis(long value) {
            this.totalThrottledTimeInMillis = value;
            return this;
        }

        public Builder totalTime(@Nullable String value) {
            this.totalTime = value;
            return this;
        }

        public Builder totalTimeInMillis(long value) {
            this.totalTimeInMillis = value;
            return this;
        }

        @Override
        public MergesStats build() {
            return new MergesStats(this);
        }
    }
}

