/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._core;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._core.PutScriptResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.StoredScript;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class PutScriptRequest
extends RequestBase
implements JsonpSerializable {
    private final String id;
    @Nullable
    private final String context;
    @Nullable
    private final String masterTimeout;
    @Nullable
    private final String timeout;
    @Nullable
    private final StoredScript script;
    public static final JsonpDeserializer<PutScriptRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PutScriptRequest::setupPutScriptRequestDeserializer, Builder::build);
    public static final Endpoint<PutScriptRequest, PutScriptResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<PutScriptRequest, PutScriptResponse>(request -> "PUT", request -> {
        boolean _id = true;
        int _context = 2;
        int propsSet = 0;
        propsSet |= 1;
        if (request.context() != null) {
            propsSet |= 2;
        }
        if (propsSet == 1) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_scripts");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.id, buf);
            return buf.toString();
        }
        if (propsSet == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_scripts");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.id, buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(request.context, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.masterTimeout != null) {
            params.put("master_timeout", request.masterTimeout);
        }
        if (request.timeout != null) {
            params.put("timeout", request.timeout);
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, PutScriptResponse._DESERIALIZER);

    public PutScriptRequest(Builder builder) {
        this.id = Objects.requireNonNull(builder.id, "id");
        this.context = builder.context;
        this.masterTimeout = builder.masterTimeout;
        this.timeout = builder.timeout;
        this.script = builder.script;
    }

    public PutScriptRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String id() {
        return this.id;
    }

    @Nullable
    public String context() {
        return this.context;
    }

    @Nullable
    public String masterTimeout() {
        return this.masterTimeout;
    }

    @Nullable
    public String timeout() {
        return this.timeout;
    }

    @Nullable
    public StoredScript script() {
        return this.script;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.script != null) {
            generator.writeKey("script");
            this.script.serialize(generator, mapper);
        }
    }

    protected static void setupPutScriptRequestDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::script, StoredScript._DESERIALIZER, "script", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<PutScriptRequest> {
        private String id;
        @Nullable
        private String context;
        @Nullable
        private String masterTimeout;
        @Nullable
        private String timeout;
        @Nullable
        private StoredScript script;

        public Builder id(String value) {
            this.id = value;
            return this;
        }

        public Builder context(@Nullable String value) {
            this.context = value;
            return this;
        }

        public Builder masterTimeout(@Nullable String value) {
            this.masterTimeout = value;
            return this;
        }

        public Builder timeout(@Nullable String value) {
            this.timeout = value;
            return this;
        }

        public Builder script(@Nullable StoredScript value) {
            this.script = value;
            return this;
        }

        public Builder script(Function<StoredScript.Builder, ObjectBuilder<StoredScript>> fn) {
            return this.script(fn.apply(new StoredScript.Builder()).build());
        }

        @Override
        public PutScriptRequest build() {
            return new PutScriptRequest(this);
        }
    }
}

