/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._core;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._core.BulkResponse;
import co.elastic.clients.elasticsearch._core.bulk.Operation;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpSerializer;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.NdJsonpSerializable;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public final class BulkRequest<TSource>
extends RequestBase
implements NdJsonpSerializable<Object>,
JsonpSerializable {
    @Nullable
    private final String index;
    @Nullable
    private final String type;
    @Nullable
    private final String pipeline;
    @Nullable
    private final JsonValue refresh;
    @Nullable
    private final String routing;
    @Nullable
    private final JsonValue source;
    @Nullable
    private final List<String> sourceExcludes;
    @Nullable
    private final List<String> sourceIncludes;
    @Nullable
    private final String timeout;
    @Nullable
    private final JsonValue waitForActiveShards;
    @Nullable
    private final Boolean requireAlias;
    private final List<Object> operations;
    @Nullable
    private final JsonpSerializer<TSource> tSourceSerializer;
    public static final Endpoint<BulkRequest<?>, BulkResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<BulkRequest, BulkResponse>(request -> "POST", request -> {
        boolean _index = true;
        int _type = 2;
        int propsSet = 0;
        if (request.index() != null) {
            propsSet |= 1;
        }
        if (request.type() != null) {
            propsSet |= 2;
        }
        if (propsSet == 0) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_bulk");
            return buf.toString();
        }
        if (propsSet == 1) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index, buf);
            buf.append("/_bulk");
            return buf.toString();
        }
        if (propsSet == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index, buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(request.type, buf);
            buf.append("/_bulk");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.pipeline != null) {
            params.put("pipeline", request.pipeline);
        }
        if (request.refresh != null) {
            params.put("refresh", JsonpUtils.toString(request.refresh));
        }
        if (request.routing != null) {
            params.put("routing", request.routing);
        }
        if (request.source != null) {
            params.put("_source", JsonpUtils.toString(request.source));
        }
        if (request.sourceExcludes != null) {
            params.put("_source_excludes", request.sourceExcludes.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        if (request.sourceIncludes != null) {
            params.put("_source_includes", request.sourceIncludes.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        if (request.timeout != null) {
            params.put("timeout", request.timeout);
        }
        if (request.waitForActiveShards != null) {
            params.put("wait_for_active_shards", JsonpUtils.toString(request.waitForActiveShards));
        }
        if (request.requireAlias != null) {
            params.put("require_alias", String.valueOf(request.requireAlias));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, BulkResponse._DESERIALIZER);

    public BulkRequest(Builder<TSource> builder) {
        this.index = ((Builder)builder).index;
        this.type = ((Builder)builder).type;
        this.pipeline = ((Builder)builder).pipeline;
        this.refresh = ((Builder)builder).refresh;
        this.routing = ((Builder)builder).routing;
        this.source = ((Builder)builder).source;
        this.sourceExcludes = ModelTypeHelper.unmodifiable(((Builder)builder).sourceExcludes);
        this.sourceIncludes = ModelTypeHelper.unmodifiable(((Builder)builder).sourceIncludes);
        this.timeout = ((Builder)builder).timeout;
        this.waitForActiveShards = ((Builder)builder).waitForActiveShards;
        this.requireAlias = ((Builder)builder).requireAlias;
        this.operations = ModelTypeHelper.unmodifiableNonNull(((Builder)builder).operations, "_value_body");
        this.tSourceSerializer = ((Builder)builder).tSourceSerializer;
    }

    public BulkRequest(Function<Builder<TSource>, Builder<TSource>> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public String index() {
        return this.index;
    }

    @Nullable
    public String type() {
        return this.type;
    }

    @Nullable
    public String pipeline() {
        return this.pipeline;
    }

    @Nullable
    public JsonValue refresh() {
        return this.refresh;
    }

    @Nullable
    public String routing() {
        return this.routing;
    }

    @Nullable
    public JsonValue source() {
        return this.source;
    }

    @Nullable
    public List<String> sourceExcludes() {
        return this.sourceExcludes;
    }

    @Nullable
    public List<String> sourceIncludes() {
        return this.sourceIncludes;
    }

    @Nullable
    public String timeout() {
        return this.timeout;
    }

    @Nullable
    public JsonValue waitForActiveShards() {
        return this.waitForActiveShards;
    }

    @Nullable
    public Boolean requireAlias() {
        return this.requireAlias;
    }

    public List<Object> operations() {
        return this.operations;
    }

    @Override
    public Iterator<Object> iterator() {
        return this.operations.iterator();
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartArray();
        for (Object item0 : this.operations) {
            mapper.serialize(item0, generator);
        }
        generator.writeEnd();
    }

    public static class Builder<TSource>
    implements ObjectBuilder<BulkRequest<TSource>> {
        @Nullable
        private String index;
        @Nullable
        private String type;
        @Nullable
        private String pipeline;
        @Nullable
        private JsonValue refresh;
        @Nullable
        private String routing;
        @Nullable
        private JsonValue source;
        @Nullable
        private List<String> sourceExcludes;
        @Nullable
        private List<String> sourceIncludes;
        @Nullable
        private String timeout;
        @Nullable
        private JsonValue waitForActiveShards;
        @Nullable
        private Boolean requireAlias;
        private List<Object> operations;
        @Nullable
        private JsonpSerializer<TSource> tSourceSerializer;

        public Builder<TSource> index(@Nullable String value) {
            this.index = value;
            return this;
        }

        public Builder<TSource> type(@Nullable String value) {
            this.type = value;
            return this;
        }

        public Builder<TSource> pipeline(@Nullable String value) {
            this.pipeline = value;
            return this;
        }

        public Builder<TSource> refresh(@Nullable JsonValue value) {
            this.refresh = value;
            return this;
        }

        public Builder<TSource> routing(@Nullable String value) {
            this.routing = value;
            return this;
        }

        public Builder<TSource> source(@Nullable JsonValue value) {
            this.source = value;
            return this;
        }

        public Builder<TSource> sourceExcludes(@Nullable List<String> value) {
            this.sourceExcludes = value;
            return this;
        }

        public Builder<TSource> sourceExcludes(String ... value) {
            this.sourceExcludes = Arrays.asList(value);
            return this;
        }

        public Builder<TSource> addSourceExcludes(String value) {
            if (this.sourceExcludes == null) {
                this.sourceExcludes = new ArrayList<String>();
            }
            this.sourceExcludes.add(value);
            return this;
        }

        public Builder<TSource> sourceIncludes(@Nullable List<String> value) {
            this.sourceIncludes = value;
            return this;
        }

        public Builder<TSource> sourceIncludes(String ... value) {
            this.sourceIncludes = Arrays.asList(value);
            return this;
        }

        public Builder<TSource> addSourceIncludes(String value) {
            if (this.sourceIncludes == null) {
                this.sourceIncludes = new ArrayList<String>();
            }
            this.sourceIncludes.add(value);
            return this;
        }

        public Builder<TSource> timeout(@Nullable String value) {
            this.timeout = value;
            return this;
        }

        public Builder<TSource> waitForActiveShards(@Nullable JsonValue value) {
            this.waitForActiveShards = value;
            return this;
        }

        public Builder<TSource> requireAlias(@Nullable Boolean value) {
            this.requireAlias = value;
            return this;
        }

        public Builder<TSource> operations(List<Object> value) {
            this.operations = value;
            return this;
        }

        public Builder<TSource> operations(Object ... value) {
            this.operations = Arrays.asList(value);
            return this;
        }

        public Builder<TSource> addOperation(Operation value) {
            if (this.operations == null) {
                this.operations = new ArrayList<Object>();
            }
            this.operations.add(value);
            return this;
        }

        public Builder<TSource> addDocument(TSource value) {
            if (this.operations == null) {
                this.operations = new ArrayList<Object>();
            }
            this.operations.add(value);
            return this;
        }

        public Builder<TSource> addOperation(Function<Operation.Builder, ObjectBuilder<Operation>> fn) {
            return this.addOperation(fn.apply(new Operation.Builder()).build());
        }

        public Builder<TSource> tSourceSerializer(@Nullable JsonpSerializer<TSource> value) {
            this.tSourceSerializer = value;
            return this;
        }

        @Override
        public BulkRequest<TSource> build() {
            return new BulkRequest(this);
        }
    }
}

