/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.web;

import co.elastic.apm.matcher.WildcardMatcher;
import co.elastic.apm.matcher.WildcardMatcherValueConverter;
import co.elastic.apm.shaded.stagemonitor.configuration.ConfigurationOption;
import co.elastic.apm.shaded.stagemonitor.configuration.ConfigurationOptionProvider;
import co.elastic.apm.shaded.stagemonitor.configuration.converter.ListValueConverter;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class WebConfiguration
extends ConfigurationOptionProvider {
    private static final String HTTP_CATEGORY = "HTTP";
    private final ConfigurationOption<EventType> captureBody = ConfigurationOption.enumOption(EventType.class).key("capture_body").configurationCategory("HTTP").description("For transactions that are HTTP requests, the Java agent can optionally capture the request body (e.g. POST variables).\n\nPossible values: errors, transactions, all, off.\n\nIf the request has a body and this setting is disabled, the body will be shown as [REDACTED].\n\nFor requests with a content type of multipart/form-data, any uploaded files will be referenced in a special _files key. It contains the name of the field, and the name of the uploaded file, if provided.\n\nWARNING: request bodies often contain sensitive values like passwords, credit card numbers etc.If your service handles data like this, we advise to only enable this feature with care.").dynamic(true).buildWithDefault(EventType.OFF);
    private final ConfigurationOption<List<WildcardMatcher>> ignoreUrls = ConfigurationOption.builder(new ListValueConverter<WildcardMatcher>(new WildcardMatcherValueConverter()), List.class).key("ignore_urls").configurationCategory("HTTP").description("Used to restrict requests to certain URLs from being instrumented.\n\nThis property should be set to an array containing one or more strings.\nWhen an incoming HTTP request is detected, its URL will be tested against each element in this list.\nEntries can have a wildcard at the beginning and at the end.\nPrepending an element with `(?i)` makes the matching case-insensitive.\n\nNOTE: All errors that are captured during a request to an ignored URL are still sent to the APM Server regardless of this setting.").dynamic(true).buildWithDefault(Arrays.asList(WildcardMatcher.valueOf("/VAADIN/*"), WildcardMatcher.valueOf("(?i)/heartbeat/*"), WildcardMatcher.valueOf("/favicon.ico"), WildcardMatcher.valueOf("*.js"), WildcardMatcher.valueOf("*.css"), WildcardMatcher.valueOf("*.jpg"), WildcardMatcher.valueOf("*.jpeg"), WildcardMatcher.valueOf("*.png"), WildcardMatcher.valueOf("*.webp"), WildcardMatcher.valueOf("*.svg"), WildcardMatcher.valueOf("*.woff"), WildcardMatcher.valueOf("*.woff2")));
    private final ConfigurationOption<List<WildcardMatcher>> ignoreUserAgents = ConfigurationOption.builder(new ListValueConverter<WildcardMatcher>(new WildcardMatcherValueConverter()), List.class).key("ignore_user_agents").configurationCategory("HTTP").description("Used to restrict requests from certain User-Agents from being instrumented.\n\nWhen an incoming HTTP request is detected,\nthe User-Agent from the request headers will be tested against each element in this list.\nEntries can have a wildcard at the beginning and at the end.\nPrepending an element with `(?i)` makes the matching case-insensitive.\nExample: `curl/*, (?i)*pingdom*`\n\nNOTE: All errors that are captured during a request by an ignored user agent are still sent to the APM Server regardless of this setting.").dynamic(true).buildWithDefault(Collections.emptyList());

    public EventType getCaptureBody() {
        return this.captureBody.get();
    }

    public List<WildcardMatcher> getIgnoreUrls() {
        return this.ignoreUrls.get();
    }

    public List<WildcardMatcher> getIgnoreUserAgents() {
        return this.ignoreUserAgents.get();
    }

    public static enum EventType {
        OFF,
        ERRORS,
        TRANSACTIONS,
        ALL;

    }
}

