/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.web;

import co.elastic.apm.configuration.CoreConfiguration;
import co.elastic.apm.impl.context.Context;
import co.elastic.apm.impl.context.Request;
import co.elastic.apm.impl.error.ErrorCapture;
import co.elastic.apm.impl.transaction.Transaction;
import co.elastic.apm.matcher.WildcardMatcher;
import co.elastic.apm.report.processor.Processor;
import co.elastic.apm.shaded.stagemonitor.configuration.ConfigurationRegistry;
import co.elastic.apm.util.PotentiallyMultiValuedMap;
import javax.annotation.Nullable;

public class SanitizingWebProcessor
implements Processor {
    static final String REDACTED = "[REDACTED]";
    @Nullable
    private CoreConfiguration config;

    @Override
    public void init(ConfigurationRegistry configurationRegistry) {
        this.config = configurationRegistry.getConfig(CoreConfiguration.class);
    }

    @Override
    public void processBeforeReport(Transaction transaction) {
        this.sanitizeContext(transaction.getContext());
    }

    @Override
    public void processBeforeReport(ErrorCapture error) {
        this.sanitizeContext(error.getContext());
    }

    private void sanitizeContext(Context context) {
        this.sanitizeRequest(context.getRequest());
        this.sanitizeMap(context.getResponse().getHeaders());
    }

    private void sanitizeRequest(Request request) {
        this.sanitizeMap(request.getHeaders());
        request.getHeaders().removeIgnoreCase("Cookie");
        this.sanitizeMap(request.getFormUrlEncodedParameters());
        this.sanitizeMap(request.getCookies());
    }

    private void sanitizeMap(PotentiallyMultiValuedMap map) {
        for (int i = 0; i < map.size(); ++i) {
            if (!this.isSensitive(map.getKey(i))) continue;
            map.set(i, REDACTED);
        }
    }

    private boolean isSensitive(String key) {
        assert (this.config != null);
        return WildcardMatcher.anyMatch(this.config.getSanitizeFieldNames(), key);
    }
}

