/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.web;

import co.elastic.apm.impl.context.Context;
import co.elastic.apm.impl.context.Request;
import co.elastic.apm.impl.error.ErrorCapture;
import co.elastic.apm.impl.transaction.Transaction;
import co.elastic.apm.report.processor.Processor;
import co.elastic.apm.shaded.stagemonitor.configuration.ConfigurationRegistry;
import co.elastic.apm.web.WebConfiguration;
import javax.annotation.Nullable;

public class BodyProcessor
implements Processor {
    @Nullable
    private WebConfiguration webConfiguration;

    @Override
    public void init(ConfigurationRegistry configurationRegistry) {
        this.webConfiguration = configurationRegistry.getConfig(WebConfiguration.class);
    }

    @Override
    public void processBeforeReport(Transaction transaction) {
        this.redactBodyIfNecessary(transaction.getContext(), WebConfiguration.EventType.TRANSACTIONS);
    }

    @Override
    public void processBeforeReport(ErrorCapture error) {
        this.redactBodyIfNecessary(error.getContext(), WebConfiguration.EventType.ERRORS);
    }

    private void redactBodyIfNecessary(Context context, WebConfiguration.EventType eventType) {
        assert (this.webConfiguration != null);
        WebConfiguration.EventType eventTypeConfig = this.webConfiguration.getCaptureBody();
        if (this.hasBody(context.getRequest()) && eventTypeConfig != eventType && eventTypeConfig != WebConfiguration.EventType.ALL) {
            context.getRequest().redactBody();
        }
    }

    private boolean hasBody(Request request) {
        return request.getBody() != null;
    }
}

