/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.annotation.Nullable;

public final class VersionUtils {
    private VersionUtils() {
    }

    @Nullable
    public static String getVersionFromPomProperties(Class clazz, String groupId, String artifactId) {
        String classpathLocation = "META-INF/maven/" + groupId + "/" + artifactId + "/pom.properties";
        Properties pomProperties = VersionUtils.getFromClasspath(classpathLocation, clazz.getClassLoader());
        if (pomProperties != null) {
            return pomProperties.getProperty("version");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static Properties getFromClasspath(String classpathLocation, ClassLoader classLoader) {
        Properties props = new Properties();
        InputStream resourceStream = classLoader.getResourceAsStream(classpathLocation);
        if (resourceStream != null) {
            try {
                props.load(resourceStream);
                Properties properties = props;
                return properties;
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    resourceStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }
}

