/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.util;

import co.elastic.apm.shaded.dslplatform.json.JsonWriter;

public class HexUtils {
    private static final char[] hexArray = "0123456789abcdef".toCharArray();

    private HexUtils() {
    }

    public static String bytesToHex(byte[] bytes) {
        StringBuilder sb = new StringBuilder(bytes.length * 2);
        HexUtils.writeBytesAsHex(bytes, sb);
        return sb.toString();
    }

    public static void writeBytesAsHex(byte[] bytes, JsonWriter jw) {
        for (int i = 0; i < bytes.length; ++i) {
            int v = bytes[i] & 0xFF;
            jw.writeByte((byte)hexArray[v >>> 4]);
            jw.writeByte((byte)hexArray[v & 0xF]);
        }
    }

    public static void writeBytesAsHex(byte[] bytes, StringBuilder sb) {
        for (int i = 0; i < bytes.length; ++i) {
            HexUtils.writeByteAsHex(bytes[i], sb);
        }
    }

    public static void writeByteAsHex(byte b, StringBuilder sb) {
        int v = b & 0xFF;
        sb.append(hexArray[v >>> 4]);
        sb.append(hexArray[v & 0xF]);
    }

    public static void writeLongAsHex(long l, JsonWriter jw) {
        for (int i = 7; i >= 0; --i) {
            int v = (int)l & 0xFF;
            jw.writeByte((byte)hexArray[v >>> 4]);
            jw.writeByte((byte)hexArray[v & 0xF]);
            l >>= 8;
        }
    }

    public static byte getNextByte(String hexEncodedString, int offset) {
        return (byte)((Character.digit(hexEncodedString.charAt(offset), 16) << 4) + Character.digit(hexEncodedString.charAt(offset + 1), 16));
    }

    public static void nextBytes(String hexEncodedString, int offset, byte[] bytes) {
        for (int i = 0; i < bytes.length * 2; i += 2) {
            bytes[i / 2] = HexUtils.getNextByte(hexEncodedString, offset + i);
        }
    }
}

