/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.util;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class ExecutorUtils {
    private ExecutorUtils() {
    }

    public static ScheduledThreadPoolExecutor createSingleThreadSchedulingDeamonPool(String threadName, int queueCapacity) {
        NamedThreadFactory daemonThreadFactory = new NamedThreadFactory(threadName);
        return new ScheduledThreadPoolExecutor(queueCapacity, daemonThreadFactory);
    }

    public static ThreadPoolExecutor createSingleThreadDeamonPool(String threadName, int queueCapacity) {
        NamedThreadFactory daemonThreadFactory = new NamedThreadFactory(threadName);
        return new NamedDaemonThreadPoolExecutor(queueCapacity, daemonThreadFactory, threadName);
    }

    private static class NamedDaemonThreadPoolExecutor
    extends ThreadPoolExecutor {
        private final String threadName;

        NamedDaemonThreadPoolExecutor(int queueCapacity, ThreadFactory daemonThreadFactory, String threadName) {
            super(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(queueCapacity), daemonThreadFactory);
            this.threadName = threadName;
        }

        @Override
        public String toString() {
            return super.toString() + "(thread name = " + this.threadName + ")";
        }

        @Override
        protected void afterExecute(Runnable r, Throwable t) {
            super.afterExecute(r, t);
            if (t == null && r instanceof Future) {
                try {
                    Future future = (Future)((Object)r);
                    if (future.isDone()) {
                        future.get();
                    }
                }
                catch (CancellationException ce) {
                    t = ce;
                }
                catch (ExecutionException ee) {
                    t = ee.getCause();
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
            }
            if (t != null) {
                t.printStackTrace();
            }
        }
    }

    public static class NamedThreadFactory
    implements ThreadFactory {
        private final String threadName;

        NamedThreadFactory(String threadName) {
            this.threadName = threadName;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r);
            thread.setDaemon(true);
            thread.setName(this.threadName);
            return thread;
        }
    }
}

