/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.spring.webmvc;

import co.elastic.apm.bci.ElasticApmInstrumentation;
import co.elastic.apm.impl.ElasticApmTracer;
import co.elastic.apm.impl.transaction.Transaction;
import co.elastic.apm.shaded.bytebuddy.asm.Advice;
import co.elastic.apm.shaded.bytebuddy.description.method.MethodDescription;
import co.elastic.apm.shaded.bytebuddy.description.type.TypeDescription;
import co.elastic.apm.shaded.bytebuddy.matcher.ElementMatcher;
import co.elastic.apm.shaded.bytebuddy.matcher.ElementMatchers;
import javax.annotation.Nullable;
import org.springframework.web.method.HandlerMethod;

public class SpringTransactionNameInstrumentation
extends ElasticApmInstrumentation {
    @Override
    public void init(ElasticApmTracer tracer) {
        HandlerAdapterAdvice.tracer = tracer;
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.not(ElementMatchers.isInterface()).and(ElementMatchers.nameStartsWith("org.springframework.web.servlet")).and(ElementMatchers.hasSuperType(ElementMatchers.named("org.springframework.web.servlet.HandlerAdapter")));
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("handle").and(ElementMatchers.returns(ElementMatchers.named("org.springframework.web.servlet.ModelAndView"))).and(ElementMatchers.takesArgument(0, ElementMatchers.named("javax.servlet.http.HttpServletRequest"))).and(ElementMatchers.takesArgument(1, ElementMatchers.named("javax.servlet.http.HttpServletResponse"))).and(ElementMatchers.takesArgument(2, Object.class));
    }

    @Override
    public Class<?> getAdviceClass() {
        return HandlerAdapterAdvice.class;
    }

    @Override
    public String getInstrumentationGroupName() {
        return "spring-mvc";
    }

    public static class HandlerAdapterAdvice {
        @Nullable
        public static ElasticApmTracer tracer;

        @Advice.OnMethodEnter
        static void setTransactionName(@Advice.Argument(value=2) Object handler) {
            Transaction transaction;
            if (tracer != null && (transaction = tracer.currentTransaction()) != null) {
                String methodName;
                String className;
                if (handler instanceof HandlerMethod) {
                    HandlerMethod handlerMethod = (HandlerMethod)handler;
                    className = handlerMethod.getBeanType().getSimpleName();
                    methodName = handlerMethod.getMethod().getName();
                } else {
                    className = handler.getClass().getSimpleName();
                    methodName = null;
                }
                HandlerAdapterAdvice.setName(transaction, className, methodName);
            }
        }

        public static void setName(Transaction transaction, String className, @Nullable String methodName) {
            StringBuilder name = transaction.getName();
            name.setLength(0);
            name.append(className);
            if (methodName != null) {
                name.append('#').append(methodName);
            }
        }
    }
}

