/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.shaded.stagemonitor.util;

import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.TimeZone;
import java.util.regex.Pattern;

public class StringUtils {
    private static final Pattern CAMEL_CASE = Pattern.compile("(?<=[A-Z])(?=[A-Z][a-z])|(?<=[^A-Z])(?=[A-Z])|(?<=[A-Za-z])(?=[^A-Za-z])");
    private static final char[] hexArray = "0123456789abcdef".toCharArray();

    private StringUtils() {
    }

    public static String removeStart(String str, String remove) {
        if (remove != null && str.startsWith(remove)) {
            return str.substring(remove.length());
        }
        return str;
    }

    public static String capitalize(String self) {
        return Character.toUpperCase(self.charAt(0)) + self.substring(1);
    }

    public static String splitCamelCase(String s) {
        return CAMEL_CASE.matcher(s).replaceAll(" ");
    }

    public static String[] split(String str, char separatorChar) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        if (len == 0) {
            return new String[0];
        }
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        int start = 0;
        boolean match = false;
        while (i < len) {
            if (str.charAt(i) == separatorChar) {
                if (match) {
                    list.add(str.substring(start, i));
                    match = false;
                }
                start = ++i;
                continue;
            }
            match = true;
            ++i;
        }
        if (match) {
            list.add(str.substring(start, i));
        }
        return list.toArray(new String[list.size()]);
    }

    public static String dateAsIsoString(Date date) {
        TimeZone tz = TimeZone.getDefault();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        df.setTimeZone(tz);
        return df.format(date);
    }

    public static String timestampAsIsoString(long timestamp) {
        return StringUtils.dateAsIsoString(new Date(timestamp));
    }

    public static String slugify(String s) {
        return StringUtils.replaceWhitespacesWithDash(s.toLowerCase().replaceAll("[^\\w ]+", ""));
    }

    public static boolean isNotEmpty(String s) {
        return !StringUtils.isEmpty(s);
    }

    public static boolean isEmpty(String s) {
        return s == null || s.isEmpty();
    }

    public static String asCsv(String[] strings) {
        return StringUtils.asCsv(Arrays.asList(strings));
    }

    public static String asCsv(Collection<?> values) {
        if (values == null) {
            return null;
        }
        String s = new ArrayList(values).toString();
        return s.substring(1, s.length() - 1);
    }

    public static String getLogstashStyleDate() {
        return StringUtils.getLogstashStyleDate(System.currentTimeMillis());
    }

    public static String getLogstashStyleDate(long time) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy.MM.dd");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return dateFormat.format(new Date(time));
    }

    public static String replaceWhitespacesWithDash(String s) {
        if (s == null) {
            return null;
        }
        return s.replaceAll("\\s", "-");
    }

    public static String toCommaSeparatedString(String ... strings) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < strings.length; ++i) {
            String value = strings[i];
            if (i > 0) {
                sb.append(",");
            }
            sb.append(value);
        }
        return sb.toString();
    }

    public static String removeTrailingSlash(String url) {
        if (url != null && url.endsWith("/")) {
            return url.substring(0, url.length() - 1);
        }
        return url;
    }

    public static String sha1Hash(String s) {
        MessageDigest messageDigest;
        if (s == null) {
            return null;
        }
        try {
            messageDigest = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
        byte[] digest = messageDigest.digest(s.getBytes(Charset.forName("UTF-8")));
        return StringUtils.bytesToHex(digest);
    }

    public static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    public static String toHexString(long l) {
        return String.format("%x", l);
    }

    public static String deDot(String s) {
        return s.replace(".", "_(dot)_");
    }

    public static String reDot(String s) {
        return s.replace("_(dot)_", ".");
    }
}

