/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.shaded.stagemonitor.configuration.source;

import co.elastic.apm.shaded.slf4j.Logger;
import co.elastic.apm.shaded.slf4j.LoggerFactory;
import co.elastic.apm.shaded.stagemonitor.configuration.source.AbstractConfigurationSource;

public class SystemPropertyConfigurationSource
extends AbstractConfigurationSource {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public String getValue(String key) {
        try {
            return System.getProperty(key);
        }
        catch (SecurityException e) {
            this.logger.warn("Could not get Java system property, because of a SecurityException: {}", (Object)e.getMessage());
            return null;
        }
    }

    @Override
    public String getName() {
        return "Java System Properties";
    }
}

