/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.shaded.stagemonitor.configuration.converter;

import co.elastic.apm.shaded.stagemonitor.configuration.converter.AbstractValueConverter;
import co.elastic.apm.shaded.stagemonitor.configuration.converter.RegexValueConverter;
import co.elastic.apm.shaded.stagemonitor.configuration.converter.StringValueConverter;
import co.elastic.apm.shaded.stagemonitor.configuration.converter.ValueConverter;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class MapValueConverter<K, V>
extends AbstractValueConverter<Map<K, V>> {
    private final ValueConverter<K> keyValueConverter;
    private final ValueConverter<V> valueValueConverter;
    private String valueSeparator;
    private String entrySeparator;
    public static final ValueConverter<Map<Pattern, String>> REGEX_MAP_VALUE_CONVERTER = new MapValueConverter<Pattern, String>(RegexValueConverter.INSTANCE, StringValueConverter.INSTANCE);

    public MapValueConverter(ValueConverter<K> keyValueConverter, ValueConverter<V> valueValueConverter) {
        this(keyValueConverter, valueValueConverter, ":", ",");
    }

    public MapValueConverter(ValueConverter<K> keyValueConverter, ValueConverter<V> valueValueConverter, String valueSeparator, String entrySeparator) {
        this.keyValueConverter = keyValueConverter;
        this.valueValueConverter = valueValueConverter;
        this.valueSeparator = valueSeparator;
        this.entrySeparator = entrySeparator;
    }

    @Override
    public Map<K, V> convert(String s) {
        if (s == null || s.trim().isEmpty()) {
            return Collections.emptyMap();
        }
        try {
            String[] groups = s.trim().split(this.entrySeparator);
            LinkedHashMap<K, V> map = new LinkedHashMap<K, V>(groups.length);
            for (String group : groups) {
                String[] keyValue = (group = group.trim()).split(this.valueSeparator);
                if (keyValue.length != 2) {
                    throw new IllegalArgumentException();
                }
                map.put(this.keyValueConverter.convert(keyValue[0].trim()), this.valueValueConverter.convert(keyValue[1].trim()));
            }
            return Collections.unmodifiableMap(map);
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException("Error while parsing map. Expected format <regex>: <name>[, <regex>: <name>]. Actual value: '" + s + ".'", e);
        }
    }

    @Override
    public String toString(Map<K, V> value) {
        return this.getString(value, false);
    }

    @Override
    public String toSafeString(Map<K, V> value) {
        return this.getString(value, true);
    }

    private String getString(Map<K, V> map, boolean safeString) {
        if (map == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        Iterator<Map.Entry<K, V>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<K, V> entry = iterator.next();
            K key = entry.getKey();
            V value = entry.getValue();
            sb.append(safeString ? this.keyValueConverter.toSafeString(key) : this.keyValueConverter.toString(key)).append(this.valueSeparator).append(' ').append(safeString ? this.valueValueConverter.toSafeString(value) : this.valueValueConverter.toString(value));
            if (!iterator.hasNext()) continue;
            sb.append(this.entrySeparator).append('\n');
        }
        return sb.toString();
    }
}

