/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.shaded.stagemonitor.configuration.converter;

import co.elastic.apm.shaded.stagemonitor.configuration.converter.AbstractValueConverter;
import co.elastic.apm.shaded.stagemonitor.configuration.converter.ValueConverter;
import java.util.Collection;
import java.util.Iterator;

public abstract class AbstractCollectionValueConverter<C extends Collection<V>, V>
extends AbstractValueConverter<C> {
    protected final ValueConverter<V> valueConverter;

    public AbstractCollectionValueConverter(ValueConverter<V> valueConverter) {
        this.valueConverter = valueConverter;
    }

    @Override
    public String toString(C value) {
        return this.getString(value, false);
    }

    @Override
    public String toSafeString(C value) {
        return this.getString(value, true);
    }

    private String getString(C value, boolean safeString) {
        Iterator it = value.iterator();
        if (!it.hasNext()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        while (true) {
            Object e = it.next();
            if (safeString) {
                sb.append(this.valueConverter.toSafeString(e));
            } else {
                sb.append(this.valueConverter.toString(e));
            }
            if (!it.hasNext()) {
                return sb.toString();
            }
            sb.append(',');
        }
    }
}

