/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.shaded.okhttp3.internal.platform;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

class OptionalMethod<T> {
    private final Class<?> returnType;
    private final String methodName;
    private final Class[] methodParams;

    OptionalMethod(Class<?> returnType, String methodName, Class ... methodParams) {
        this.returnType = returnType;
        this.methodName = methodName;
        this.methodParams = methodParams;
    }

    public boolean isSupported(T target) {
        return this.getMethod(target.getClass()) != null;
    }

    public Object invokeOptional(T target, Object ... args) throws InvocationTargetException {
        Method m = this.getMethod(target.getClass());
        if (m == null) {
            return null;
        }
        try {
            return m.invoke(target, args);
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    public Object invokeOptionalWithoutCheckedException(T target, Object ... args) {
        try {
            return this.invokeOptional(target, args);
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            if (targetException instanceof RuntimeException) {
                throw (RuntimeException)targetException;
            }
            AssertionError error = new AssertionError((Object)"Unexpected exception");
            ((Throwable)((Object)error)).initCause(targetException);
            throw error;
        }
    }

    public Object invoke(T target, Object ... args) throws InvocationTargetException {
        Method m = this.getMethod(target.getClass());
        if (m == null) {
            throw new AssertionError((Object)("Method " + this.methodName + " not supported for object " + target));
        }
        try {
            return m.invoke(target, args);
        }
        catch (IllegalAccessException e) {
            AssertionError error = new AssertionError((Object)("Unexpectedly could not call: " + m));
            ((Throwable)((Object)error)).initCause(e);
            throw error;
        }
    }

    public Object invokeWithoutCheckedException(T target, Object ... args) {
        try {
            return this.invoke(target, args);
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            if (targetException instanceof RuntimeException) {
                throw (RuntimeException)targetException;
            }
            AssertionError error = new AssertionError((Object)"Unexpected exception");
            ((Throwable)((Object)error)).initCause(targetException);
            throw error;
        }
    }

    private Method getMethod(Class<?> clazz) {
        Method method = null;
        if (this.methodName != null && (method = OptionalMethod.getPublicMethod(clazz, this.methodName, this.methodParams)) != null && this.returnType != null && !this.returnType.isAssignableFrom(method.getReturnType())) {
            method = null;
        }
        return method;
    }

    private static Method getPublicMethod(Class<?> clazz, String methodName, Class[] parameterTypes) {
        Method method = null;
        try {
            method = clazz.getMethod(methodName, parameterTypes);
            if ((method.getModifiers() & 1) == 0) {
                method = null;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return method;
    }
}

