/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.shaded.lmax.disruptor;

import co.elastic.apm.shaded.lmax.disruptor.AlertException;
import co.elastic.apm.shaded.lmax.disruptor.Sequence;
import co.elastic.apm.shaded.lmax.disruptor.SequenceBarrier;
import co.elastic.apm.shaded.lmax.disruptor.WaitStrategy;
import co.elastic.apm.shaded.lmax.disruptor.util.ThreadHints;

public final class BusySpinWaitStrategy
implements WaitStrategy {
    @Override
    public long waitFor(long sequence, Sequence cursor, Sequence dependentSequence, SequenceBarrier barrier) throws AlertException, InterruptedException {
        long availableSequence;
        while ((availableSequence = dependentSequence.get()) < sequence) {
            barrier.checkAlert();
            ThreadHints.onSpinWait();
        }
        return availableSequence;
    }

    @Override
    public void signalAllWhenBlocking() {
    }
}

