/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.shaded.jctools.queues;

import co.elastic.apm.shaded.jctools.queues.BaseMpscLinkedArrayQueue;
import co.elastic.apm.shaded.jctools.util.Pow2;
import co.elastic.apm.shaded.jctools.util.RangeUtil;

abstract class MpscChunkedArrayQueueColdProducerFields<E>
extends BaseMpscLinkedArrayQueue<E> {
    protected final long maxQueueCapacity;

    MpscChunkedArrayQueueColdProducerFields(int initialCapacity, int maxCapacity) {
        super(initialCapacity);
        RangeUtil.checkGreaterThanOrEqual(maxCapacity, 4, "maxCapacity");
        RangeUtil.checkLessThan(Pow2.roundToPowerOfTwo(initialCapacity), Pow2.roundToPowerOfTwo(maxCapacity), "initialCapacity");
        this.maxQueueCapacity = (long)Pow2.roundToPowerOfTwo(maxCapacity) << 1;
    }
}

