/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.shaded.dslplatform.json;

import co.elastic.apm.shaded.dslplatform.json.JsonReader;
import co.elastic.apm.shaded.dslplatform.json.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public abstract class NumberConverter {
    private static final int[] DIGITS = new int[1000];
    private static final int[] DIFF = new int[]{111, 222, 444, 888, 1776};
    private static final int[] ERROR = new int[]{50, 100, 200, 400, 800};
    private static final int[] SCALE_10 = new int[]{10000, 1000, 100, 10, 1};
    private static final double[] POW_10 = new double[]{10.0, 100.0, 1000.0, 10000.0, 100000.0, 1000000.0, 1.0E7, 1.0E8, 1.0E9, 1.0E10, 1.0E11, 1.0E12, 1.0E13, 1.0E14, 1.0E15, 1.0E16, 1.0E17, 1.0E18, 1.0E19, 1.0E20, 1.0E21, 1.0E22, 1.0E23, 1.0E24, 1.0E25, 1.0E26, 1.0E27, 1.0E28, 1.0E29, 1.0E30, 1.0E31, 1.0E32, 1.0E33, 1.0E34, 1.0E35, 1.0E36, 1.0E37, 1.0E38, 1.0E39, 1.0E40, 1.0E41, 1.0E42, 1.0E43, 1.0E44, 1.0E45, 1.0E46};
    public static final JsonReader.ReadObject<Double> DOUBLE_READER = new JsonReader.ReadObject<Double>(){

        @Override
        public Double read(JsonReader reader) throws IOException {
            return NumberConverter.deserializeDouble(reader);
        }
    };
    public static final JsonReader.ReadObject<Double> NULLABLE_DOUBLE_READER = new JsonReader.ReadObject<Double>(){

        @Override
        public Double read(JsonReader reader) throws IOException {
            return reader.wasNull() ? null : Double.valueOf(NumberConverter.deserializeDouble(reader));
        }
    };
    public static final JsonWriter.WriteObject<Double> DOUBLE_WRITER = new JsonWriter.WriteObject<Double>(){

        @Override
        public void write(JsonWriter writer, Double value) {
            NumberConverter.serializeNullable(value, writer);
        }
    };
    public static final JsonReader.ReadObject<double[]> DOUBLE_ARRAY_READER = new JsonReader.ReadObject<double[]>(){

        @Override
        public double[] read(JsonReader reader) throws IOException {
            if (reader.wasNull()) {
                return null;
            }
            if (reader.last() != 91) {
                throw reader.expecting("[");
            }
            reader.getNextToken();
            return NumberConverter.deserializeDoubleArray(reader);
        }
    };
    public static final JsonWriter.WriteObject<double[]> DOUBLE_ARRAY_WRITER = new JsonWriter.WriteObject<double[]>(){

        @Override
        public void write(JsonWriter writer, double[] value) {
            NumberConverter.serialize(value, writer);
        }
    };
    public static final JsonReader.ReadObject<Float> FLOAT_READER = new JsonReader.ReadObject<Float>(){

        @Override
        public Float read(JsonReader reader) throws IOException {
            return Float.valueOf(NumberConverter.deserializeFloat(reader));
        }
    };
    public static final JsonReader.ReadObject<Float> NULLABLE_FLOAT_READER = new JsonReader.ReadObject<Float>(){

        @Override
        public Float read(JsonReader reader) throws IOException {
            return reader.wasNull() ? null : Float.valueOf(NumberConverter.deserializeFloat(reader));
        }
    };
    public static final JsonWriter.WriteObject<Float> FLOAT_WRITER = new JsonWriter.WriteObject<Float>(){

        @Override
        public void write(JsonWriter writer, Float value) {
            NumberConverter.serializeNullable(value, writer);
        }
    };
    public static final JsonReader.ReadObject<float[]> FLOAT_ARRAY_READER = new JsonReader.ReadObject<float[]>(){

        @Override
        public float[] read(JsonReader reader) throws IOException {
            if (reader.wasNull()) {
                return null;
            }
            if (reader.last() != 91) {
                throw reader.expecting("[");
            }
            reader.getNextToken();
            return NumberConverter.deserializeFloatArray(reader);
        }
    };
    public static final JsonWriter.WriteObject<float[]> FLOAT_ARRAY_WRITER = new JsonWriter.WriteObject<float[]>(){

        @Override
        public void write(JsonWriter writer, float[] value) {
            NumberConverter.serialize(value, writer);
        }
    };
    public static final JsonReader.ReadObject<Integer> INT_READER = new JsonReader.ReadObject<Integer>(){

        @Override
        public Integer read(JsonReader reader) throws IOException {
            return NumberConverter.deserializeInt(reader);
        }
    };
    public static final JsonReader.ReadObject<Integer> NULLABLE_INT_READER = new JsonReader.ReadObject<Integer>(){

        @Override
        public Integer read(JsonReader reader) throws IOException {
            return reader.wasNull() ? null : Integer.valueOf(NumberConverter.deserializeInt(reader));
        }
    };
    public static final JsonWriter.WriteObject<Integer> INT_WRITER = new JsonWriter.WriteObject<Integer>(){

        @Override
        public void write(JsonWriter writer, Integer value) {
            NumberConverter.serializeNullable(value, writer);
        }
    };
    public static final JsonReader.ReadObject<int[]> INT_ARRAY_READER = new JsonReader.ReadObject<int[]>(){

        @Override
        public int[] read(JsonReader reader) throws IOException {
            if (reader.wasNull()) {
                return null;
            }
            if (reader.last() != 91) {
                throw reader.expecting("[");
            }
            reader.getNextToken();
            return NumberConverter.deserializeIntArray(reader);
        }
    };
    public static final JsonWriter.WriteObject<int[]> INT_ARRAY_WRITER = new JsonWriter.WriteObject<int[]>(){

        @Override
        public void write(JsonWriter writer, int[] value) {
            NumberConverter.serialize(value, writer);
        }
    };
    public static final JsonReader.ReadObject<Short> ShortReader = new JsonReader.ReadObject<Short>(){

        @Override
        public Short read(JsonReader reader) throws IOException {
            return (short)NumberConverter.deserializeInt(reader);
        }
    };
    static final JsonReader.ReadObject<Short> NullableShortReader = new JsonReader.ReadObject<Short>(){

        @Override
        public Short read(JsonReader reader) throws IOException {
            return reader.wasNull() ? null : Short.valueOf((short)NumberConverter.deserializeInt(reader));
        }
    };
    static final JsonWriter.WriteObject<Short> ShortWriter = new JsonWriter.WriteObject<Short>(){

        @Override
        public void write(JsonWriter writer, Short value) {
            if (value == null) {
                writer.writeNull();
            } else {
                NumberConverter.serialize(value.intValue(), writer);
            }
        }
    };
    static final JsonReader.ReadObject<short[]> ShortArrayReader = new JsonReader.ReadObject<short[]>(){

        @Override
        public short[] read(JsonReader reader) throws IOException {
            if (reader.wasNull()) {
                return null;
            }
            if (reader.last() != 91) {
                throw reader.expecting("[");
            }
            reader.getNextToken();
            return NumberConverter.deserializeShortArray(reader);
        }
    };
    public static final JsonWriter.WriteObject<short[]> ShortArrayWriter = new JsonWriter.WriteObject<short[]>(){

        @Override
        public void write(JsonWriter writer, short[] value) {
            NumberConverter.serialize(value, writer);
        }
    };
    public static final JsonReader.ReadObject<Long> LONG_READER = new JsonReader.ReadObject<Long>(){

        @Override
        public Long read(JsonReader reader) throws IOException {
            return NumberConverter.deserializeLong(reader);
        }
    };
    public static final JsonReader.ReadObject<Long> NULLABLE_LONG_READER = new JsonReader.ReadObject<Long>(){

        @Override
        public Long read(JsonReader reader) throws IOException {
            return reader.wasNull() ? null : Long.valueOf(NumberConverter.deserializeLong(reader));
        }
    };
    public static final JsonWriter.WriteObject<Long> LONG_WRITER = new JsonWriter.WriteObject<Long>(){

        @Override
        public void write(JsonWriter writer, Long value) {
            NumberConverter.serializeNullable(value, writer);
        }
    };
    public static final JsonReader.ReadObject<long[]> LONG_ARRAY_READER = new JsonReader.ReadObject<long[]>(){

        @Override
        public long[] read(JsonReader reader) throws IOException {
            if (reader.wasNull()) {
                return null;
            }
            if (reader.last() != 91) {
                throw reader.expecting("[");
            }
            reader.getNextToken();
            return NumberConverter.deserializeLongArray(reader);
        }
    };
    public static final JsonWriter.WriteObject<long[]> LONG_ARRAY_WRITER = new JsonWriter.WriteObject<long[]>(){

        @Override
        public void write(JsonWriter writer, long[] value) {
            NumberConverter.serialize(value, writer);
        }
    };
    public static final JsonReader.ReadObject<BigDecimal> DecimalReader = new JsonReader.ReadObject<BigDecimal>(){

        @Override
        public BigDecimal read(JsonReader reader) throws IOException {
            return reader.wasNull() ? null : NumberConverter.deserializeDecimal(reader);
        }
    };
    public static final JsonWriter.WriteObject<BigDecimal> DecimalWriter = new JsonWriter.WriteObject<BigDecimal>(){

        @Override
        public void write(JsonWriter writer, BigDecimal value) {
            NumberConverter.serializeNullable(value, writer);
        }
    };
    static final JsonReader.ReadObject<Number> NumberReader = new JsonReader.ReadObject<Number>(){

        @Override
        public Number read(JsonReader reader) throws IOException {
            return reader.wasNull() ? (Number)null : (Number)NumberConverter.deserializeNumber(reader);
        }
    };
    private static final byte MINUS = 45;
    private static final byte[] MIN_INT;
    private static final int[] emptyIntArray;
    private static final short[] emptyShortArray;
    private static final long[] emptyLongArray;
    private static final float[] emptyFloatArray;
    private static final double[] emptyDoubleArray;
    private static final byte[] MIN_LONG;
    private static final BigDecimal BD_MAX_LONG;
    private static final BigDecimal BD_MIN_LONG;

    static void write4(int value, byte[] buf, int pos) {
        if (value > 9999) {
            throw new IllegalArgumentException("Only 4 digits numbers are supported. Provided: " + value);
        }
        int q = value / 1000;
        int v = DIGITS[value - q * 1000];
        buf[pos] = (byte)(q + 48);
        buf[pos + 1] = (byte)(v >> 16);
        buf[pos + 2] = (byte)(v >> 8);
        buf[pos + 3] = (byte)v;
    }

    static void write3(int number, byte[] buf, int pos) {
        int v = DIGITS[number];
        buf[pos] = (byte)(v >> 16);
        buf[pos + 1] = (byte)(v >> 8);
        buf[pos + 2] = (byte)v;
    }

    static void write2(int value, byte[] buf, int pos) {
        int v = DIGITS[value];
        buf[pos] = (byte)(v >> 8);
        buf[pos + 1] = (byte)v;
    }

    static int read2(char[] buf, int pos) {
        int v1 = buf[pos] - 48;
        return (v1 << 3) + (v1 << 1) + buf[pos + 1] - 48;
    }

    static int read4(char[] buf, int pos) {
        int v2 = buf[pos + 1] - 48;
        int v3 = buf[pos + 2] - 48;
        return (buf[pos] - 48) * 1000 + (v2 << 6) + (v2 << 5) + (v2 << 2) + (v3 << 3) + (v3 << 1) + buf[pos + 3] - 48;
    }

    private static void numberException(JsonReader reader, int start, int end, String message) throws IOException {
        int len = end - start;
        char[] buf = reader.prepareBuffer(reader.getCurrentIndex() - len, len);
        if (len < reader.maxNumberDigits) {
            NumberFormatException error = new NumberFormatException(new String(buf, 0, len));
            throw new IOException("Error parsing number " + reader.positionDescription(len) + ". " + message, error);
        }
        throw new IOException("Error parsing number " + reader.positionDescription(len) + ". " + message);
    }

    public static void serializeNullable(Double value, JsonWriter sw) {
        if (value == null) {
            sw.writeNull();
        } else {
            NumberConverter.serialize(value, sw);
        }
    }

    private static BigDecimal parseNumberGeneric(char[] buf, int len, JsonReader reader) throws IOException {
        int end;
        for (end = len; end > 0 && Character.isWhitespace(buf[end - 1]); --end) {
        }
        try {
            return new BigDecimal(buf, 0, end);
        }
        catch (NumberFormatException nfe) {
            throw new IOException("Error parsing number " + reader.positionDescription(len), nfe);
        }
    }

    public static void serialize(double value, JsonWriter sw) {
        sw.writeDouble(value);
    }

    public static void serialize(double[] value, JsonWriter sw) {
        if (value == null) {
            sw.writeNull();
        } else if (value.length == 0) {
            sw.writeAscii("[]");
        } else {
            sw.writeByte((byte)91);
            NumberConverter.serialize(value[0], sw);
            for (int i = 1; i < value.length; ++i) {
                sw.writeByte((byte)44);
                NumberConverter.serialize(value[i], sw);
            }
            sw.writeByte((byte)93);
        }
    }

    private static NumberInfo readLongNumber(JsonReader reader, int start) throws IOException {
        int i = reader.length() - start;
        char[] tmp = reader.prepareBuffer(start, i);
        long position = reader.positionInStream();
        while (!reader.isEndOfStream()) {
            while (i < tmp.length) {
                char ch = (char)reader.read();
                tmp[i++] = ch;
                if (!reader.isEndOfStream() && (ch >= '0' && ch <= '9' || ch == '-' || ch == '+' || ch == '.' || ch == 'e' || ch == 'E')) continue;
                return new NumberInfo(tmp, i);
            }
            int newSize = tmp.length * 2;
            if (newSize > reader.maxNumberDigits) {
                throw new IOException("Unable to read number at: " + position + ". Number of digits larger than " + reader.maxNumberDigits);
            }
            tmp = Arrays.copyOf(tmp, newSize);
        }
        return new NumberInfo(tmp, i);
    }

    public static double deserializeDouble(JsonReader reader) throws IOException {
        if (reader.last() == 34) {
            int position = reader.getCurrentIndex();
            char[] buf = reader.readSimpleQuote();
            return NumberConverter.parseDoubleGeneric(buf, reader.getCurrentIndex() - position - 1, reader);
        }
        int start = reader.scanNumber();
        int end = reader.getCurrentIndex();
        byte[] buf = reader.buffer;
        byte ch = buf[start];
        if (ch == 45) {
            return -NumberConverter.parseDouble(buf, reader, start, end, 1);
        }
        return NumberConverter.parseDouble(buf, reader, start, end, 0);
    }

    private static double parseDouble(byte[] buf, JsonReader reader, int start, int end, int offset) throws IOException {
        int i;
        if (end - start - offset > reader.doubleLengthLimit) {
            if (end == reader.length()) {
                NumberInfo tmp = NumberConverter.readLongNumber(reader, start + offset);
                return NumberConverter.parseDoubleGeneric(tmp.buffer, tmp.length, reader);
            }
            return NumberConverter.parseDoubleGeneric(reader.prepareBuffer(start + offset, end - start - offset), end - start - offset, reader);
        }
        long value = 0L;
        int ch = 32;
        for (i = start + offset; i < end && (ch = buf[i]) != 46 && ch != 101 && ch != 69; ++i) {
            int ind = buf[i] - 48;
            if (ind < 0 || ind > 9) {
                if (i > start + offset && reader.allWhitespace(i, end)) {
                    return value;
                }
                NumberConverter.numberException(reader, start, end, "Unknown digit: " + (char)ch);
            }
            value = (value << 3) + (value << 1) + (long)ind;
        }
        if (i == start + offset) {
            NumberConverter.numberException(reader, start, end, "Digit not found");
        } else {
            if (i == end) {
                return value;
            }
            if (ch == 46) {
                int numLimit;
                int decOffset;
                int expDiff;
                double preciseDividor;
                int maxLen;
                if (++i == end) {
                    NumberConverter.numberException(reader, start, end, "Number ends with a dot");
                }
                int decPos = i;
                if (value == 0L) {
                    maxLen = i + 15;
                    ch = buf[i];
                    if (ch == 48 && end > maxLen) {
                        return NumberConverter.parseDoubleGeneric(reader.prepareBuffer(start + offset, end - start - offset), end - start - offset, reader);
                    }
                    if (ch < 56) {
                        preciseDividor = 1.0E14;
                        expDiff = -1;
                        decOffset = 1;
                    } else {
                        preciseDividor = 1.0E15;
                        expDiff = 0;
                        decOffset = 0;
                    }
                } else {
                    maxLen = start + offset + 16;
                    if (buf[start + offset] < 56) {
                        preciseDividor = 1.0E14;
                        expDiff = i - maxLen + 14;
                        decOffset = 1;
                    } else {
                        preciseDividor = 1.0E15;
                        expDiff = i - maxLen + 15;
                        decOffset = 0;
                    }
                }
                int n = numLimit = maxLen < end ? maxLen : end;
                while (i < numLimit && (ch = buf[i]) != 101 && ch != 69) {
                    int ind = ch - 48;
                    if (ind < 0 || ind > 9) {
                        if (reader.allWhitespace(i, end)) {
                            return (double)value / POW_10[i - decPos - 1];
                        }
                        NumberConverter.numberException(reader, start, end, "Unknown digit: " + (char)buf[i]);
                    }
                    value = (value << 3) + (value << 1) + (long)ind;
                    ++i;
                }
                if (i == end) {
                    return (double)value / POW_10[i - decPos - 1];
                }
                if (ch == 101 || ch == 69) {
                    return NumberConverter.doubleExponent(reader, value, i - decPos, 0.0, buf, start, end, offset, i);
                }
                if (reader.doublePrecision == JsonReader.DoublePrecision.HIGH) {
                    return NumberConverter.parseDoubleGeneric(reader.prepareBuffer(start + offset, end - start - offset), end - start - offset, reader);
                }
                int decimals = 0;
                int decLimit = start + offset + 18 < end ? start + offset + 18 : end;
                int remPos = i;
                while (i < decLimit && (ch = buf[i]) != 101 && ch != 69) {
                    int ind = ch - 48;
                    if (ind < 0 || ind > 9) {
                        if (reader.allWhitespace(i, end)) {
                            return NumberConverter.approximateDouble(decimals, (double)value / preciseDividor, i - remPos - decOffset);
                        }
                        NumberConverter.numberException(reader, start, end, "Unknown digit: " + (char)buf[i]);
                    }
                    decimals = (decimals << 3) + (decimals << 1) + ind;
                    ++i;
                }
                double number = NumberConverter.approximateDouble(decimals, (double)value / preciseDividor, i - remPos - decOffset);
                while (i < end && ch >= 48 && ch <= 57) {
                    ch = buf[i++];
                }
                if (ch == 101 || ch == 69) {
                    return NumberConverter.doubleExponent(reader, 0L, expDiff, number, buf, start, end, offset, i);
                }
                if (expDiff > 0) {
                    return number * POW_10[expDiff - 1];
                }
                if (expDiff < 0) {
                    return number / POW_10[-expDiff - 1];
                }
                return number;
            }
            if (ch == 101 || ch == 69) {
                return NumberConverter.doubleExponent(reader, value, 0, 0.0, buf, start, end, offset, i);
            }
        }
        return value;
    }

    private static double approximateDouble(int decimals, double precise, int digits) {
        long bits = Double.doubleToRawLongBits(precise);
        int exp = (int)(bits >> 52) - 1022;
        int missing = (decimals * SCALE_10[digits + 1] + ERROR[exp]) / DIFF[exp];
        return Double.longBitsToDouble(bits + (long)missing);
    }

    private static double doubleExponent(JsonReader reader, long whole, int decimals, double fraction, byte[] buf, int start, int end, int offset, int i) throws IOException {
        byte ch;
        if (reader.doublePrecision == JsonReader.DoublePrecision.EXACT) {
            return NumberConverter.parseDoubleGeneric(reader.prepareBuffer(start + offset, end - start - offset), end - start - offset, reader);
        }
        int exp = (ch = buf[++i]) == 45 ? NumberConverter.parseNegativeInt(buf, reader, i, end) - decimals : (ch == 43 ? NumberConverter.parsePositiveInt(buf, reader, i, end, 1) - decimals : NumberConverter.parsePositiveInt(buf, reader, i, end, 0) - decimals);
        if (fraction == 0.0) {
            if (exp == 0) {
                return whole;
            }
            if (exp > 0 && exp < POW_10.length) {
                return (double)whole * POW_10[exp - 1];
            }
            if (exp < 0 && -exp < POW_10.length) {
                return (double)whole / POW_10[-exp - 1];
            }
            if (reader.doublePrecision != JsonReader.DoublePrecision.HIGH) {
                if (exp > 0 && exp < 300) {
                    return (double)whole * Math.pow(10.0, exp);
                }
                if (exp > -300 && exp < 0) {
                    return (double)whole / Math.pow(10.0, exp);
                }
            }
        } else {
            if (exp == 0) {
                return (double)whole + fraction;
            }
            if (exp > 0 && exp < POW_10.length) {
                return fraction * POW_10[exp - 1] + (double)whole * POW_10[exp - 1];
            }
            if (exp < 0 && -exp < POW_10.length) {
                return fraction / POW_10[-exp - 1] + (double)whole / POW_10[-exp - 1];
            }
            if (reader.doublePrecision != JsonReader.DoublePrecision.HIGH) {
                if (exp > 0 && exp < 300) {
                    return (double)whole * Math.pow(10.0, exp);
                }
                if (exp > -300 && exp < 0) {
                    return (double)whole / Math.pow(10.0, exp);
                }
            }
        }
        return NumberConverter.parseDoubleGeneric(reader.prepareBuffer(start + offset, end - start - offset), end - start - offset, reader);
    }

    private static double parseDoubleGeneric(char[] buf, int len, JsonReader reader) throws IOException {
        int end;
        for (end = len; end > 0 && Character.isWhitespace(buf[end - 1]); --end) {
        }
        try {
            return Double.parseDouble(new String(buf, 0, end));
        }
        catch (NumberFormatException nfe) {
            throw new IOException("Error parsing number " + reader.positionDescription(len), nfe);
        }
    }

    public static ArrayList<Double> deserializeDoubleCollection(JsonReader reader) throws IOException {
        return reader.deserializeCollection(DOUBLE_READER);
    }

    public static void deserializeDoubleCollection(JsonReader reader, Collection<Double> res) throws IOException {
        reader.deserializeCollection(DOUBLE_READER, res);
    }

    public static ArrayList<Double> deserializeDoubleNullableCollection(JsonReader reader) throws IOException {
        return reader.deserializeNullableCollection(DOUBLE_READER);
    }

    public static void deserializeDoubleNullableCollection(JsonReader reader, Collection<Double> res) throws IOException {
        reader.deserializeNullableCollection(DOUBLE_READER, res);
    }

    public static void serializeNullable(Float value, JsonWriter sw) {
        if (value == null) {
            sw.writeNull();
        } else {
            NumberConverter.serialize(value.floatValue(), sw);
        }
    }

    public static void serialize(float value, JsonWriter sw) {
        if (value == Float.POSITIVE_INFINITY) {
            sw.writeAscii("\"Infinity\"");
        } else if (value == Float.NEGATIVE_INFINITY) {
            sw.writeAscii("\"-Infinity\"");
        } else if (value != value) {
            sw.writeAscii("\"NaN\"");
        } else {
            sw.writeAscii(Float.toString(value));
        }
    }

    public static void serialize(float[] value, JsonWriter sw) {
        if (value == null) {
            sw.writeNull();
        } else if (value.length == 0) {
            sw.writeAscii("[]");
        } else {
            sw.writeByte((byte)91);
            NumberConverter.serialize(value[0], sw);
            for (int i = 1; i < value.length; ++i) {
                sw.writeByte((byte)44);
                NumberConverter.serialize(value[i], sw);
            }
            sw.writeByte((byte)93);
        }
    }

    public static float deserializeFloat(JsonReader reader) throws IOException {
        if (reader.last() == 34) {
            int position = reader.getCurrentIndex();
            char[] buf = reader.readSimpleQuote();
            return NumberConverter.parseFloatGeneric(buf, reader.getCurrentIndex() - position - 1, reader);
        }
        int start = reader.scanNumber();
        int end = reader.getCurrentIndex();
        if (end == reader.length()) {
            NumberInfo tmp = NumberConverter.readLongNumber(reader, start);
            return NumberConverter.parseFloatGeneric(tmp.buffer, tmp.length, reader);
        }
        byte[] buf = reader.buffer;
        byte ch = buf[start];
        if (ch == 45) {
            return -NumberConverter.parseFloat(buf, reader, start, end, 1);
        }
        return NumberConverter.parseFloat(buf, reader, start, end, 0);
    }

    private static float parseFloat(byte[] buf, JsonReader reader, int start, int end, int offset) throws IOException {
        int i;
        long value = 0L;
        int ch = 32;
        int digitStart = i = start + offset;
        while (i < end && (ch = buf[i]) != 46 && ch != 101 && ch != 69) {
            int ind = ch - 48;
            if (ind < 0 || ind > 9) {
                if (i > start + offset && reader.allWhitespace(i, end)) {
                    return value;
                }
                NumberConverter.numberException(reader, start, end, "Unknown digit: " + (char)ch);
            }
            value = (value << 3) + (value << 1) + (long)ind;
            ++i;
        }
        if (i == digitStart) {
            NumberConverter.numberException(reader, start, end, "Digit not found");
        } else {
            if (i > 18 + digitStart) {
                return (float)NumberConverter.parseDoubleGeneric(reader.prepareBuffer(start, end - start), end - start, reader);
            }
            if (i == end) {
                return value;
            }
            if (ch == 46) {
                int numLimit;
                int maxLen;
                if (++i == end) {
                    NumberConverter.numberException(reader, start, end, "Number ends with a dot");
                }
                int dp = i;
                if (value == 0L) {
                    while (i < end && buf[i] == 48) {
                        ++i;
                    }
                    maxLen = i + 12;
                } else {
                    maxLen = digitStart + 12;
                }
                int n = numLimit = maxLen < end ? maxLen : end;
                while (i < numLimit && (ch = buf[i]) != 101 && ch != 69) {
                    int ind = ch - 48;
                    if (ind < 0 || ind > 9) {
                        if (reader.allWhitespace(i, end)) {
                            return (float)((double)value / POW_10[i - dp - 1]);
                        }
                        NumberConverter.numberException(reader, start, end, "Unknown digit: " + (char)ch);
                    }
                    value = (value << 3) + (value << 1) + (long)ind;
                    ++i;
                }
                double number = (double)value / POW_10[i - dp - 1];
                while (i < end && ch >= 48 && ch <= 57) {
                    ch = buf[i++];
                }
                while (i == end && reader.length() == end) {
                    i = reader.scanNumber();
                    end = reader.getCurrentIndex();
                    buf = reader.buffer;
                    while (i < end && ch >= 48 && ch <= 57) {
                        ch = buf[i++];
                    }
                }
                if (ch == 101 || ch == 69) {
                    int exp;
                    if ((exp = (ch = buf[++i]) == 45 ? NumberConverter.parseNegativeInt(buf, reader, i, end) : (ch == 43 ? NumberConverter.parsePositiveInt(buf, reader, i, end, 1) : NumberConverter.parsePositiveInt(buf, reader, i, end, 0))) == 0) {
                        return (float)number;
                    }
                    if (exp > 0 && exp < POW_10.length) {
                        return (float)(number * POW_10[exp - 1]);
                    }
                    if (exp < 0 && -exp < POW_10.length) {
                        return (float)(number / POW_10[-exp - 1]);
                    }
                    if (exp > 0) {
                        return Float.POSITIVE_INFINITY;
                    }
                    return 0.0f;
                }
                return (float)number;
            }
            if (ch == 101 || ch == 69) {
                int exp;
                if ((exp = (ch = buf[++i]) == 45 ? NumberConverter.parseNegativeInt(buf, reader, i, end) : (ch == 43 ? NumberConverter.parsePositiveInt(buf, reader, i, end, 1) : NumberConverter.parsePositiveInt(buf, reader, i, end, 0))) == 0) {
                    return value;
                }
                if (exp > 0 && exp < POW_10.length) {
                    return (float)((double)value * POW_10[exp - 1]);
                }
                if (exp < 0 && -exp < POW_10.length) {
                    return (float)((double)value / POW_10[-exp - 1]);
                }
                if (exp > 0) {
                    return Float.POSITIVE_INFINITY;
                }
                return 0.0f;
            }
        }
        return value;
    }

    private static float parseFloatGeneric(char[] buf, int len, JsonReader reader) throws IOException {
        int end;
        for (end = len; end > 0 && Character.isWhitespace(buf[end - 1]); --end) {
        }
        try {
            return Float.parseFloat(new String(buf, 0, end));
        }
        catch (NumberFormatException nfe) {
            throw new IOException("Error parsing number " + reader.positionDescription(len), nfe);
        }
    }

    public static ArrayList<Float> deserializeFloatCollection(JsonReader reader) throws IOException {
        return reader.deserializeCollection(FLOAT_READER);
    }

    public static void deserializeFloatCollection(JsonReader reader, Collection<Float> res) throws IOException {
        reader.deserializeCollection(FLOAT_READER, res);
    }

    public static ArrayList<Float> deserializeFloatNullableCollection(JsonReader reader) throws IOException {
        return reader.deserializeNullableCollection(FLOAT_READER);
    }

    public static void deserializeFloatNullableCollection(JsonReader reader, Collection<Float> res) throws IOException {
        reader.deserializeNullableCollection(FLOAT_READER, res);
    }

    public static void serializeNullable(Integer value, JsonWriter sw) {
        if (value == null) {
            sw.writeNull();
        } else {
            NumberConverter.serialize(value, sw);
        }
    }

    public static void serialize(int value, JsonWriter sw) {
        byte[] buf = sw.ensureCapacity(11);
        int position = sw.size();
        int current = NumberConverter.serialize(buf, position, value);
        sw.advance(current - position);
    }

    private static int serialize(byte[] buf, int pos, int value) {
        int i;
        if (value < 0) {
            if (value == Integer.MIN_VALUE) {
                for (int x = 0; x < MIN_INT.length; ++x) {
                    buf[pos + x] = MIN_INT[x];
                }
                return pos + MIN_INT.length;
            }
            i = -value;
            buf[pos++] = 45;
        } else {
            i = value;
        }
        int q1 = i / 1000;
        if (q1 == 0) {
            pos += NumberConverter.writeFirstBuf(buf, DIGITS[i], pos);
            return pos;
        }
        int r1 = i - q1 * 1000;
        int q2 = q1 / 1000;
        if (q2 == 0) {
            int v1 = DIGITS[r1];
            int v2 = DIGITS[q1];
            int off = NumberConverter.writeFirstBuf(buf, v2, pos);
            NumberConverter.writeBuf(buf, v1, pos + off);
            return pos + 3 + off;
        }
        int r2 = q1 - q2 * 1000;
        int q3 = q2 / 1000;
        int v1 = DIGITS[r1];
        int v2 = DIGITS[r2];
        if (q3 == 0) {
            pos += NumberConverter.writeFirstBuf(buf, DIGITS[q2], pos);
        } else {
            int r3 = q2 - q3 * 1000;
            buf[pos++] = (byte)(q3 + 48);
            NumberConverter.writeBuf(buf, DIGITS[r3], pos);
            pos += 3;
        }
        NumberConverter.writeBuf(buf, v2, pos);
        NumberConverter.writeBuf(buf, v1, pos + 3);
        return pos + 6;
    }

    public static void serialize(int[] values, JsonWriter sw) {
        if (values == null) {
            sw.writeNull();
        } else if (values.length == 0) {
            sw.writeAscii("[]");
        } else {
            byte[] buf = sw.ensureCapacity(values.length * 11 + 2);
            int position = sw.size();
            buf[position++] = 91;
            position = NumberConverter.serialize(buf, position, values[0]);
            for (int i = 1; i < values.length; ++i) {
                buf[position++] = 44;
                position = NumberConverter.serialize(buf, position, values[i]);
            }
            buf[position++] = 93;
            sw.advance(position - sw.size());
        }
    }

    public static void serialize(short[] value, JsonWriter sw) {
        if (value == null) {
            sw.writeNull();
        } else if (value.length == 0) {
            sw.writeAscii("[]");
        } else {
            sw.writeByte((byte)91);
            NumberConverter.serialize(value[0], sw);
            for (int i = 1; i < value.length; ++i) {
                sw.writeByte((byte)44);
                NumberConverter.serialize(value[i], sw);
            }
            sw.writeByte((byte)93);
        }
    }

    public static int deserializeInt(JsonReader reader) throws IOException {
        if (reader.last() == 34) {
            int position = reader.getCurrentIndex();
            char[] buf = reader.readSimpleQuote();
            try {
                return NumberConverter.parseNumberGeneric(buf, reader.getCurrentIndex() - position - 1, reader).intValueExact();
            }
            catch (ArithmeticException ignore) {
                throw new IOException("Integer overflow detected " + reader.positionDescription(reader.getCurrentIndex() - position));
            }
        }
        int start = reader.scanNumber();
        int end = reader.getCurrentIndex();
        byte[] buf = reader.buffer;
        byte ch = buf[start];
        if (ch == 45) {
            return NumberConverter.parseNegativeInt(buf, reader, start, end);
        }
        return NumberConverter.parsePositiveInt(buf, reader, start, end, 0);
    }

    private static int parsePositiveInt(byte[] buf, JsonReader reader, int start, int end, int offset) throws IOException {
        int value = 0;
        int i = start + offset;
        if (i == end) {
            NumberConverter.numberException(reader, start, end, "Digit not found");
        }
        while (i < end) {
            int ind = buf[i] - 48;
            if (ind < 0 || ind > 9) {
                BigDecimal v;
                if (i > start + offset && reader.allWhitespace(i, end)) {
                    return value;
                }
                if (i == end - 1 && buf[i] == 46) {
                    NumberConverter.numberException(reader, start, end, "Number ends with a dot");
                }
                if ((v = NumberConverter.parseNumberGeneric(reader.prepareBuffer(start, end - start), end - start, reader)).scale() > 0) {
                    NumberConverter.numberException(reader, start, end, "Expecting int but found decimal value: " + v);
                }
                return v.intValue();
            }
            if ((value = (value << 3) + (value << 1) + ind) < 0) {
                NumberConverter.numberException(reader, start, end, "Integer overflow detected");
            }
            ++i;
        }
        return value;
    }

    private static int parseNegativeInt(byte[] buf, JsonReader reader, int start, int end) throws IOException {
        int value = 0;
        int i = start + 1;
        if (i == end) {
            NumberConverter.numberException(reader, start, end, "Digit not found");
        }
        while (i < end) {
            int ind = buf[i] - 48;
            if (ind < 0 || ind > 9) {
                BigDecimal v;
                if (i > start + 1 && reader.allWhitespace(i, end)) {
                    return value;
                }
                if (i == end - 1 && buf[i] == 46) {
                    NumberConverter.numberException(reader, start, end, "Number ends with a dot");
                }
                if ((v = NumberConverter.parseNumberGeneric(reader.prepareBuffer(start, end - start), end - start, reader)).scale() > 0) {
                    NumberConverter.numberException(reader, start, end, "Expecting int but found decimal value: " + v);
                }
                return v.intValue();
            }
            if ((value = (value << 3) + (value << 1) - ind) > 0) {
                NumberConverter.numberException(reader, start, end, "Integer overflow detected");
            }
            ++i;
        }
        return value;
    }

    public static ArrayList<Integer> deserializeIntCollection(JsonReader reader) throws IOException {
        return reader.deserializeCollection(INT_READER);
    }

    public static int[] deserializeIntArray(JsonReader reader) throws IOException {
        if (reader.last() == 93) {
            return emptyIntArray;
        }
        int[] buffer = new int[4];
        buffer[0] = NumberConverter.deserializeInt(reader);
        int i = 1;
        while (reader.getNextToken() == 44) {
            reader.getNextToken();
            if (i == buffer.length) {
                buffer = Arrays.copyOf(buffer, buffer.length << 1);
            }
            buffer[i++] = NumberConverter.deserializeInt(reader);
        }
        reader.checkArrayEnd();
        return Arrays.copyOf(buffer, i);
    }

    public static short[] deserializeShortArray(JsonReader reader) throws IOException {
        if (reader.last() == 93) {
            return emptyShortArray;
        }
        short[] buffer = new short[4];
        buffer[0] = (short)NumberConverter.deserializeInt(reader);
        int i = 1;
        while (reader.getNextToken() == 44) {
            reader.getNextToken();
            if (i == buffer.length) {
                buffer = Arrays.copyOf(buffer, buffer.length << 1);
            }
            buffer[i++] = (short)NumberConverter.deserializeInt(reader);
        }
        reader.checkArrayEnd();
        return Arrays.copyOf(buffer, i);
    }

    public static long[] deserializeLongArray(JsonReader reader) throws IOException {
        if (reader.last() == 93) {
            return emptyLongArray;
        }
        long[] buffer = new long[4];
        buffer[0] = NumberConverter.deserializeLong(reader);
        int i = 1;
        while (reader.getNextToken() == 44) {
            reader.getNextToken();
            if (i == buffer.length) {
                buffer = Arrays.copyOf(buffer, buffer.length << 1);
            }
            buffer[i++] = NumberConverter.deserializeLong(reader);
        }
        reader.checkArrayEnd();
        return Arrays.copyOf(buffer, i);
    }

    public static float[] deserializeFloatArray(JsonReader reader) throws IOException {
        if (reader.last() == 93) {
            return emptyFloatArray;
        }
        float[] buffer = new float[4];
        buffer[0] = NumberConverter.deserializeFloat(reader);
        int i = 1;
        while (reader.getNextToken() == 44) {
            reader.getNextToken();
            if (i == buffer.length) {
                buffer = Arrays.copyOf(buffer, buffer.length << 1);
            }
            buffer[i++] = NumberConverter.deserializeFloat(reader);
        }
        reader.checkArrayEnd();
        return Arrays.copyOf(buffer, i);
    }

    public static double[] deserializeDoubleArray(JsonReader reader) throws IOException {
        if (reader.last() == 93) {
            return emptyDoubleArray;
        }
        double[] buffer = new double[4];
        buffer[0] = NumberConverter.deserializeDouble(reader);
        int i = 1;
        while (reader.getNextToken() == 44) {
            reader.getNextToken();
            if (i == buffer.length) {
                buffer = Arrays.copyOf(buffer, buffer.length << 1);
            }
            buffer[i++] = NumberConverter.deserializeDouble(reader);
        }
        reader.checkArrayEnd();
        return Arrays.copyOf(buffer, i);
    }

    public static void deserializeIntCollection(JsonReader reader, Collection<Integer> res) throws IOException {
        reader.deserializeCollection(INT_READER, res);
    }

    public static ArrayList<Integer> deserializeIntNullableCollection(JsonReader reader) throws IOException {
        return reader.deserializeNullableCollection(INT_READER);
    }

    public static void deserializeIntNullableCollection(JsonReader reader, Collection<Integer> res) throws IOException {
        reader.deserializeNullableCollection(INT_READER, res);
    }

    public static void serializeNullable(Long value, JsonWriter sw) {
        if (value == null) {
            sw.writeNull();
        } else {
            NumberConverter.serialize(value, sw);
        }
    }

    private static int writeFirstBuf(byte[] buf, int v, int pos) {
        int start = v >> 24;
        if (start == 0) {
            buf[pos++] = (byte)(v >> 16);
            buf[pos++] = (byte)(v >> 8);
        } else if (start == 1) {
            buf[pos++] = (byte)(v >> 8);
        }
        buf[pos] = (byte)v;
        return 3 - start;
    }

    private static void writeBuf(byte[] buf, int v, int pos) {
        buf[pos] = (byte)(v >> 16);
        buf[pos + 1] = (byte)(v >> 8);
        buf[pos + 2] = (byte)v;
    }

    public static void serialize(long value, JsonWriter sw) {
        byte[] buf = sw.ensureCapacity(21);
        int position = sw.size();
        int current = NumberConverter.serialize(buf, position, value);
        sw.advance(current - position);
    }

    private static int serialize(byte[] buf, int pos, long value) {
        long i;
        if (value < 0L) {
            if (value == Long.MIN_VALUE) {
                for (int x = 0; x < MIN_LONG.length; ++x) {
                    buf[pos + x] = MIN_LONG[x];
                }
                return pos + MIN_LONG.length;
            }
            i = -value;
            buf[pos++] = 45;
        } else {
            i = value;
        }
        long q1 = i / 1000L;
        if (q1 == 0L) {
            pos += NumberConverter.writeFirstBuf(buf, DIGITS[(int)i], pos);
            return pos;
        }
        int r1 = (int)(i - q1 * 1000L);
        long q2 = q1 / 1000L;
        if (q2 == 0L) {
            int v1 = DIGITS[r1];
            int v2 = DIGITS[(int)q1];
            int off = NumberConverter.writeFirstBuf(buf, v2, pos);
            NumberConverter.writeBuf(buf, v1, pos + off);
            return pos + 3 + off;
        }
        int r2 = (int)(q1 - q2 * 1000L);
        long q3 = q2 / 1000L;
        if (q3 == 0L) {
            int v1 = DIGITS[r1];
            int v2 = DIGITS[r2];
            int v3 = DIGITS[(int)q2];
            pos += NumberConverter.writeFirstBuf(buf, v3, pos);
            NumberConverter.writeBuf(buf, v2, pos);
            NumberConverter.writeBuf(buf, v1, pos + 3);
            return pos + 6;
        }
        int r3 = (int)(q2 - q3 * 1000L);
        int q4 = (int)(q3 / 1000L);
        if (q4 == 0) {
            int v1 = DIGITS[r1];
            int v2 = DIGITS[r2];
            int v3 = DIGITS[r3];
            int v4 = DIGITS[(int)q3];
            pos += NumberConverter.writeFirstBuf(buf, v4, pos);
            NumberConverter.writeBuf(buf, v3, pos);
            NumberConverter.writeBuf(buf, v2, pos + 3);
            NumberConverter.writeBuf(buf, v1, pos + 6);
            return pos + 9;
        }
        int r4 = (int)(q3 - (long)(q4 * 1000));
        int q5 = q4 / 1000;
        if (q5 == 0) {
            int v1 = DIGITS[r1];
            int v2 = DIGITS[r2];
            int v3 = DIGITS[r3];
            int v4 = DIGITS[r4];
            int v5 = DIGITS[q4];
            pos += NumberConverter.writeFirstBuf(buf, v5, pos);
            NumberConverter.writeBuf(buf, v4, pos);
            NumberConverter.writeBuf(buf, v3, pos + 3);
            NumberConverter.writeBuf(buf, v2, pos + 6);
            NumberConverter.writeBuf(buf, v1, pos + 9);
            return pos + 12;
        }
        int r5 = q4 - q5 * 1000;
        int q6 = q5 / 1000;
        int v1 = DIGITS[r1];
        int v2 = DIGITS[r2];
        int v3 = DIGITS[r3];
        int v4 = DIGITS[r4];
        int v5 = DIGITS[r5];
        if (q6 == 0) {
            pos += NumberConverter.writeFirstBuf(buf, DIGITS[q5], pos);
        } else {
            int r6 = q5 - q6 * 1000;
            buf[pos++] = (byte)(q6 + 48);
            NumberConverter.writeBuf(buf, DIGITS[r6], pos);
            pos += 3;
        }
        NumberConverter.writeBuf(buf, v5, pos);
        NumberConverter.writeBuf(buf, v4, pos + 3);
        NumberConverter.writeBuf(buf, v3, pos + 6);
        NumberConverter.writeBuf(buf, v2, pos + 9);
        NumberConverter.writeBuf(buf, v1, pos + 12);
        return pos + 15;
    }

    public static void serialize(long[] values, JsonWriter sw) {
        if (values == null) {
            sw.writeNull();
        } else if (values.length == 0) {
            sw.writeAscii("[]");
        } else {
            byte[] buf = sw.ensureCapacity(values.length * 21 + 2);
            int position = sw.size();
            buf[position++] = 91;
            position = NumberConverter.serialize(buf, position, values[0]);
            for (int i = 1; i < values.length; ++i) {
                buf[position++] = 44;
                position = NumberConverter.serialize(buf, position, values[i]);
            }
            buf[position++] = 93;
            sw.advance(position - sw.size());
        }
    }

    public static long deserializeLong(JsonReader reader) throws IOException {
        if (reader.last() == 34) {
            int position = reader.getCurrentIndex();
            char[] buf = reader.readSimpleQuote();
            try {
                return NumberConverter.parseNumberGeneric(buf, reader.getCurrentIndex() - position - 1, reader).longValueExact();
            }
            catch (ArithmeticException ignore) {
                throw new IOException("Long overflow detected " + reader.positionDescription(reader.getCurrentIndex() - position));
            }
        }
        int start = reader.scanNumber();
        int end = reader.getCurrentIndex();
        byte[] buf = reader.buffer;
        byte ch = buf[start];
        int i = start;
        long value = 0L;
        if (ch == 45) {
            i = start + 1;
            if (i == end) {
                NumberConverter.numberException(reader, start, end, "Digit not found");
            }
            while (i < end) {
                int ind = buf[i] - 48;
                if (ind < 0 || ind > 9) {
                    if (i > start + 1 && reader.allWhitespace(i, end)) {
                        return value;
                    }
                    return NumberConverter.parseLongGeneric(reader, start, end);
                }
                if ((value = (value << 3) + (value << 1) - (long)ind) > 0L) {
                    NumberConverter.numberException(reader, start, end, "Long overflow detected");
                }
                ++i;
            }
            return value;
        }
        if (i == end) {
            NumberConverter.numberException(reader, start, end, "Digit not found");
        }
        while (i < end) {
            int ind = buf[i] - 48;
            if (ind < 0 || ind > 9) {
                if (ch == 43 && i > start + 1 && reader.allWhitespace(i, end)) {
                    return value;
                }
                if (ch != 43 && i > start && reader.allWhitespace(i, end)) {
                    return value;
                }
                return NumberConverter.parseLongGeneric(reader, start, end);
            }
            if ((value = (value << 3) + (value << 1) + (long)ind) < 0L) {
                NumberConverter.numberException(reader, start, end, "Long overflow detected");
            }
            ++i;
        }
        return value;
    }

    private static long parseLongGeneric(JsonReader reader, int start, int end) throws IOException {
        BigDecimal v;
        int len = end - start;
        char[] buf = reader.prepareBuffer(start, len);
        if (len > 0 && buf[len - 1] == '.') {
            NumberConverter.numberException(reader, start, end, "Number ends with a dot");
        }
        if ((v = NumberConverter.parseNumberGeneric(buf, len, reader)).scale() > 0) {
            NumberConverter.numberException(reader, start, end, "Expecting long, but found decimal value: " + v);
        }
        return v.longValue();
    }

    public static ArrayList<Long> deserializeLongCollection(JsonReader reader) throws IOException {
        return reader.deserializeCollection(LONG_READER);
    }

    public static void deserializeLongCollection(JsonReader reader, Collection<Long> res) throws IOException {
        reader.deserializeCollection(LONG_READER, res);
    }

    public static ArrayList<Long> deserializeLongNullableCollection(JsonReader reader) throws IOException {
        return reader.deserializeNullableCollection(LONG_READER);
    }

    public static void deserializeLongNullableCollection(JsonReader reader, Collection<Long> res) throws IOException {
        reader.deserializeNullableCollection(LONG_READER, res);
    }

    public static void serializeNullable(BigDecimal value, JsonWriter sw) {
        if (value == null) {
            sw.writeNull();
        } else {
            sw.writeAscii(value.toString());
        }
    }

    public static void serialize(BigDecimal value, JsonWriter sw) {
        sw.writeAscii(value.toString());
    }

    public static BigDecimal deserializeDecimal(JsonReader reader) throws IOException {
        byte[] buf;
        byte ch;
        if (reader.last() == 34) {
            int len = reader.parseString();
            return NumberConverter.parseNumberGeneric(reader.chars, len, reader);
        }
        int start = reader.scanNumber();
        int end = reader.getCurrentIndex();
        int len = end - start;
        if (len > 18) {
            end = reader.findNonWhitespace(end);
            len = end - start;
            if (end == reader.length()) {
                NumberInfo info = NumberConverter.readLongNumber(reader, start);
                return NumberConverter.parseNumberGeneric(info.buffer, info.length, reader);
            }
            if (len > 18) {
                return NumberConverter.parseNumberGeneric(reader.prepareBuffer(start, len), len, reader);
            }
        }
        if ((ch = (buf = reader.buffer)[start]) == 45) {
            return NumberConverter.parseNegativeDecimal(buf, reader, start, end);
        }
        return NumberConverter.parsePositiveDecimal(buf, reader, start, end, 0);
    }

    private static BigDecimal parsePositiveDecimal(byte[] buf, JsonReader reader, int start, int end, int offset) throws IOException {
        int i;
        long value = 0L;
        int ch = 32;
        for (i = start + offset; i < end && (ch = buf[i]) != 46 && ch != 101 && ch != 69; ++i) {
            int ind = ch - 48;
            if (ind < 0 || ind > 9) {
                if (i > start + offset && reader.allWhitespace(i, end)) {
                    return BigDecimal.valueOf(value);
                }
                NumberConverter.numberException(reader, start, end, "Unknown digit: " + (char)ch);
            }
            value = (value << 3) + (value << 1) + (long)ind;
        }
        if (i == start + offset) {
            NumberConverter.numberException(reader, start, end, "Digit not found");
        } else {
            if (i == end) {
                return BigDecimal.valueOf(value);
            }
            if (ch == 46) {
                if (++i == end) {
                    NumberConverter.numberException(reader, start, end, "Number ends with a dot");
                }
                int dp = i;
                while (i < end && (ch = buf[i]) != 101 && ch != 69) {
                    int ind = ch - 48;
                    if (ind < 0 || ind > 9) {
                        if (reader.allWhitespace(i, end)) {
                            return BigDecimal.valueOf(value, i - dp);
                        }
                        NumberConverter.numberException(reader, start, end, "Unknown digit: " + (char)ch);
                    }
                    value = (value << 3) + (value << 1) + (long)ind;
                    ++i;
                }
                if (i == end) {
                    return BigDecimal.valueOf(value, end - dp);
                }
                if (ch == 101 || ch == 69) {
                    int ep = i++;
                    ch = buf[i];
                    int exp = ch == 45 ? NumberConverter.parseNegativeInt(buf, reader, i, end) : (ch == 43 ? NumberConverter.parsePositiveInt(buf, reader, i, end, 1) : NumberConverter.parsePositiveInt(buf, reader, i, end, 0));
                    return BigDecimal.valueOf(value, ep - dp - exp);
                }
                return BigDecimal.valueOf(value, end - dp);
            }
            if (ch == 101 || ch == 69) {
                int exp = (ch = buf[++i]) == 45 ? NumberConverter.parseNegativeInt(buf, reader, i, end) : (ch == 43 ? NumberConverter.parsePositiveInt(buf, reader, i, end, 1) : NumberConverter.parsePositiveInt(buf, reader, i, end, 0));
                return BigDecimal.valueOf(value, -exp);
            }
        }
        return BigDecimal.valueOf(value);
    }

    private static BigDecimal parseNegativeDecimal(byte[] buf, JsonReader reader, int start, int end) throws IOException {
        int i;
        long value = 0L;
        int ch = 32;
        for (i = start + 1; i < end && (ch = buf[i]) != 46 && ch != 101 && ch != 69; ++i) {
            int ind = ch - 48;
            if (ind < 0 || ind > 9) {
                if (i > start + 1 && reader.allWhitespace(i, end)) {
                    return BigDecimal.valueOf(value);
                }
                NumberConverter.numberException(reader, start, end, "Unknown digit: " + (char)ch);
            }
            value = (value << 3) + (value << 1) - (long)ind;
        }
        if (i == start + 1) {
            NumberConverter.numberException(reader, start, end, "Digit not found");
        } else {
            if (i == end) {
                return BigDecimal.valueOf(value);
            }
            if (ch == 46) {
                if (++i == end) {
                    NumberConverter.numberException(reader, start, end, "Number ends with a dot");
                }
                int dp = i;
                while (i < end && (ch = buf[i]) != 101 && ch != 69) {
                    int ind = ch - 48;
                    if (ind < 0 || ind > 9) {
                        if (reader.allWhitespace(i, end)) {
                            return BigDecimal.valueOf(value, i - dp);
                        }
                        NumberConverter.numberException(reader, start, end, "Unknown digit: " + (char)ch);
                    }
                    value = (value << 3) + (value << 1) - (long)ind;
                    ++i;
                }
                if (i == end) {
                    return BigDecimal.valueOf(value, end - dp);
                }
                if (ch == 101 || ch == 69) {
                    int ep = i++;
                    ch = buf[i];
                    int exp = ch == 45 ? NumberConverter.parseNegativeInt(buf, reader, i, end) : (ch == 43 ? NumberConverter.parsePositiveInt(buf, reader, i, end, 1) : NumberConverter.parsePositiveInt(buf, reader, i, end, 0));
                    return BigDecimal.valueOf(value, ep - dp - exp);
                }
                return BigDecimal.valueOf(value, end - dp);
            }
            if (ch == 101 || ch == 69) {
                int exp = (ch = buf[++i]) == 45 ? NumberConverter.parseNegativeInt(buf, reader, i, end) : (ch == 43 ? NumberConverter.parsePositiveInt(buf, reader, i, end, 1) : NumberConverter.parsePositiveInt(buf, reader, i, end, 0));
                return BigDecimal.valueOf(value, -exp);
            }
        }
        return BigDecimal.valueOf(value);
    }

    private static Number bigDecimalOrDouble(BigDecimal num, JsonReader.UnknownNumberParsing unknownNumbers) {
        return unknownNumbers == JsonReader.UnknownNumberParsing.LONG_AND_BIGDECIMAL ? num : Double.valueOf(num.doubleValue());
    }

    private static Number tryLongFromBigDecimal(char[] buf, int len, JsonReader reader) throws IOException {
        BigDecimal num = NumberConverter.parseNumberGeneric(buf, len, reader);
        if (num.scale() == 0 && num.precision() <= 19 && (num.signum() == 1 ? num.compareTo(BD_MAX_LONG) <= 0 : num.compareTo(BD_MIN_LONG) >= 0)) {
            return num.longValue();
        }
        return NumberConverter.bigDecimalOrDouble(num, reader.unknownNumbers);
    }

    public static Number deserializeNumber(JsonReader reader) throws IOException {
        byte[] buf;
        byte ch;
        if (reader.unknownNumbers == JsonReader.UnknownNumberParsing.BIGDECIMAL) {
            return NumberConverter.deserializeDecimal(reader);
        }
        if (reader.unknownNumbers == JsonReader.UnknownNumberParsing.DOUBLE) {
            return NumberConverter.deserializeDouble(reader);
        }
        int start = reader.scanNumber();
        int end = reader.getCurrentIndex();
        int len = end - start;
        if (len > 18) {
            end = reader.findNonWhitespace(end);
            len = end - start;
            if (end == reader.length()) {
                NumberInfo tmp = NumberConverter.readLongNumber(reader, start);
                return NumberConverter.tryLongFromBigDecimal(tmp.buffer, tmp.length, reader);
            }
            if (len > 18) {
                return NumberConverter.tryLongFromBigDecimal(reader.prepareBuffer(start, len), len, reader);
            }
        }
        if ((ch = (buf = reader.buffer)[start]) == 45) {
            return NumberConverter.parseNegativeNumber(buf, reader, start, end);
        }
        return NumberConverter.parsePositiveNumber(buf, reader, start, end);
    }

    private static Number parsePositiveNumber(byte[] buf, JsonReader reader, int start, int end) throws IOException {
        int i;
        long value = 0L;
        int ch = 32;
        for (i = start; i < end && (ch = buf[i]) != 46 && ch != 101 && ch != 69; ++i) {
            int ind = ch - 48;
            if (ind < 0 || ind > 9) {
                if (i > start && reader.allWhitespace(i, end)) {
                    return value;
                }
                return NumberConverter.tryLongFromBigDecimal(reader.prepareBuffer(start, end - start), end - start, reader);
            }
            value = (value << 3) + (value << 1) + (long)ind;
        }
        if (i == start) {
            NumberConverter.numberException(reader, start, end, "Digit not found");
        } else {
            if (i == end) {
                return value;
            }
            if (ch == 46) {
                if (++i == end) {
                    NumberConverter.numberException(reader, start, end, "Number ends with a dot");
                }
                int dp = i;
                while (i < end && (ch = buf[i]) != 101 && ch != 69) {
                    int ind = ch - 48;
                    if (ind < 0 || ind > 9) {
                        if (reader.allWhitespace(i, end)) {
                            return BigDecimal.valueOf(value, i - dp);
                        }
                        return NumberConverter.tryLongFromBigDecimal(reader.prepareBuffer(start, end - start), end - start, reader);
                    }
                    value = (value << 3) + (value << 1) + (long)ind;
                    ++i;
                }
                if (i == end) {
                    return NumberConverter.bigDecimalOrDouble(BigDecimal.valueOf(value, end - dp), reader.unknownNumbers);
                }
                if (ch == 101 || ch == 69) {
                    int ep = i++;
                    ch = buf[i];
                    int exp = ch == 45 ? NumberConverter.parseNegativeInt(buf, reader, i, end) : (ch == 43 ? NumberConverter.parsePositiveInt(buf, reader, i, end, 1) : NumberConverter.parsePositiveInt(buf, reader, i, end, 0));
                    return NumberConverter.bigDecimalOrDouble(BigDecimal.valueOf(value, ep - dp - exp), reader.unknownNumbers);
                }
                return BigDecimal.valueOf(value, end - dp);
            }
            if (ch == 101 || ch == 69) {
                int exp = (ch = buf[++i]) == 45 ? NumberConverter.parseNegativeInt(buf, reader, i, end) : (ch == 43 ? NumberConverter.parsePositiveInt(buf, reader, i, end, 1) : NumberConverter.parsePositiveInt(buf, reader, i, end, 0));
                return NumberConverter.bigDecimalOrDouble(BigDecimal.valueOf(value, -exp), reader.unknownNumbers);
            }
        }
        return NumberConverter.bigDecimalOrDouble(BigDecimal.valueOf(value), reader.unknownNumbers);
    }

    private static Number parseNegativeNumber(byte[] buf, JsonReader reader, int start, int end) throws IOException {
        int i;
        long value = 0L;
        int ch = 32;
        for (i = start + 1; i < end && (ch = buf[i]) != 46 && ch != 101 && ch != 69; ++i) {
            int ind = ch - 48;
            if (ind < 0 || ind > 9) {
                if (i > start + 1 && reader.allWhitespace(i, end)) {
                    return value;
                }
                return NumberConverter.tryLongFromBigDecimal(reader.prepareBuffer(start, end - start), end - start, reader);
            }
            value = (value << 3) + (value << 1) - (long)ind;
        }
        if (i == start + 1) {
            NumberConverter.numberException(reader, start, end, "Digit not found");
        } else {
            if (i == end) {
                return value;
            }
            if (ch == 46) {
                if (++i == end) {
                    NumberConverter.numberException(reader, start, end, "Number ends with a dot");
                }
                int dp = i;
                while (i < end && (ch = buf[i]) != 101 && ch != 69) {
                    int ind = ch - 48;
                    if (ind < 0 || ind > 9) {
                        if (reader.allWhitespace(i, end)) {
                            return BigDecimal.valueOf(value, i - dp);
                        }
                        return NumberConverter.tryLongFromBigDecimal(reader.prepareBuffer(start, end - start), end - start, reader);
                    }
                    value = (value << 3) + (value << 1) - (long)ind;
                    ++i;
                }
                if (i == end) {
                    return NumberConverter.bigDecimalOrDouble(BigDecimal.valueOf(value, end - dp), reader.unknownNumbers);
                }
                if (ch == 101 || ch == 69) {
                    int ep = i++;
                    ch = buf[i];
                    int exp = ch == 45 ? NumberConverter.parseNegativeInt(buf, reader, i, end) : (ch == 43 ? NumberConverter.parsePositiveInt(buf, reader, i, end, 1) : NumberConverter.parsePositiveInt(buf, reader, i, end, 0));
                    return NumberConverter.bigDecimalOrDouble(BigDecimal.valueOf(value, ep - dp - exp), reader.unknownNumbers);
                }
                return NumberConverter.bigDecimalOrDouble(BigDecimal.valueOf(value, end - dp), reader.unknownNumbers);
            }
            if (ch == 101 || ch == 69) {
                int exp = (ch = buf[++i]) == 45 ? NumberConverter.parseNegativeInt(buf, reader, i, end) : (ch == 43 ? NumberConverter.parsePositiveInt(buf, reader, i, end, 1) : NumberConverter.parsePositiveInt(buf, reader, i, end, 0));
                return NumberConverter.bigDecimalOrDouble(BigDecimal.valueOf(value, -exp), reader.unknownNumbers);
            }
        }
        return NumberConverter.bigDecimalOrDouble(BigDecimal.valueOf(value), reader.unknownNumbers);
    }

    public static ArrayList<BigDecimal> deserializeDecimalCollection(JsonReader reader) throws IOException {
        return reader.deserializeCollection(DecimalReader);
    }

    public static void deserializeDecimalCollection(JsonReader reader, Collection<BigDecimal> res) throws IOException {
        reader.deserializeCollection(DecimalReader, res);
    }

    public static ArrayList<BigDecimal> deserializeDecimalNullableCollection(JsonReader reader) throws IOException {
        return reader.deserializeNullableCollection(DecimalReader);
    }

    public static void deserializeDecimalNullableCollection(JsonReader reader, Collection<BigDecimal> res) throws IOException {
        reader.deserializeNullableCollection(DecimalReader, res);
    }

    static {
        for (int i = 0; i < DIGITS.length; ++i) {
            NumberConverter.DIGITS[i] = (i < 10 ? 0x2000000 : (i < 100 ? 0x1000000 : 0)) + (i / 100 + 48 << 16) + (i / 10 % 10 + 48 << 8) + i % 10 + 48;
        }
        MIN_INT = "-2147483648".getBytes();
        emptyIntArray = new int[0];
        emptyShortArray = new short[0];
        emptyLongArray = new long[0];
        emptyFloatArray = new float[0];
        emptyDoubleArray = new double[0];
        MIN_LONG = "-9223372036854775808".getBytes();
        BD_MAX_LONG = BigDecimal.valueOf(Long.MAX_VALUE);
        BD_MIN_LONG = BigDecimal.valueOf(Long.MIN_VALUE);
    }

    private static class NumberInfo {
        final char[] buffer;
        final int length;

        NumberInfo(char[] buffer, int length) {
            this.buffer = buffer;
            this.length = length;
        }
    }
}

