/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.shaded.dslplatform.json;

import co.elastic.apm.shaded.dslplatform.json.JsonReader;
import co.elastic.apm.shaded.dslplatform.json.JsonWriter;
import co.elastic.apm.shaded.dslplatform.json.StringConverter;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;

public abstract class NetConverter {
    static final JsonReader.ReadObject<URI> UriReader = new JsonReader.ReadObject<URI>(){

        @Override
        public URI read(JsonReader reader) throws IOException {
            return reader.wasNull() ? null : NetConverter.deserializeUri(reader);
        }
    };
    static final JsonWriter.WriteObject<URI> UriWriter = new JsonWriter.WriteObject<URI>(){

        @Override
        public void write(JsonWriter writer, URI value) {
            NetConverter.serializeNullable(value, writer);
        }
    };
    static final JsonReader.ReadObject<InetAddress> AddressReader = new JsonReader.ReadObject<InetAddress>(){

        @Override
        public InetAddress read(JsonReader reader) throws IOException {
            return reader.wasNull() ? null : NetConverter.deserializeIp(reader);
        }
    };
    static final JsonWriter.WriteObject<InetAddress> AddressWriter = new JsonWriter.WriteObject<InetAddress>(){

        @Override
        public void write(JsonWriter writer, InetAddress value) {
            NetConverter.serializeNullable(value, writer);
        }
    };

    public static void serializeNullable(URI value, JsonWriter sw) {
        if (value == null) {
            sw.writeNull();
        } else {
            NetConverter.serialize(value, sw);
        }
    }

    public static void serialize(URI value, JsonWriter sw) {
        StringConverter.serializeShort(value.toString(), sw);
    }

    public static URI deserializeUri(JsonReader reader) throws IOException {
        return URI.create(reader.readString());
    }

    public static ArrayList<URI> deserializeUriCollection(JsonReader reader) throws IOException {
        return reader.deserializeCollection(UriReader);
    }

    public static void deserializeUriCollection(JsonReader reader, Collection<URI> res) throws IOException {
        reader.deserializeCollection(UriReader, res);
    }

    public static ArrayList<URI> deserializeUriNullableCollection(JsonReader reader) throws IOException {
        return reader.deserializeNullableCollection(UriReader);
    }

    public static void deserializeUriNullableCollection(JsonReader reader, Collection<URI> res) throws IOException {
        reader.deserializeNullableCollection(UriReader, res);
    }

    public static void serializeNullable(InetAddress value, JsonWriter sw) {
        if (value == null) {
            sw.writeNull();
        } else {
            NetConverter.serialize(value, sw);
        }
    }

    public static void serialize(InetAddress value, JsonWriter sw) {
        sw.writeByte((byte)34);
        sw.writeAscii(value.getHostAddress());
        sw.writeByte((byte)34);
    }

    public static InetAddress deserializeIp(JsonReader reader) throws IOException {
        return InetAddress.getByName(reader.readSimpleString());
    }

    public static ArrayList<InetAddress> deserializeIpCollection(JsonReader reader) throws IOException {
        return reader.deserializeCollection(AddressReader);
    }

    public static void deserializeIpCollection(JsonReader reader, Collection<InetAddress> res) throws IOException {
        reader.deserializeCollection(AddressReader, res);
    }

    public static ArrayList<InetAddress> deserializeIpNullableCollection(JsonReader reader) throws IOException {
        return reader.deserializeNullableCollection(AddressReader);
    }

    public static void deserializeIpNullableCollection(JsonReader reader, Collection<InetAddress> res) throws IOException {
        reader.deserializeNullableCollection(AddressReader, res);
    }
}

