/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.shaded.dslplatform.json;

import co.elastic.apm.shaded.dslplatform.json.JsonReader;
import co.elastic.apm.shaded.dslplatform.json.JsonWriter;
import co.elastic.apm.shaded.dslplatform.json.StringConverter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class MapConverter {
    private static final JsonReader.ReadObject<Map<String, String>> TypedMapReader = new JsonReader.ReadObject<Map<String, String>>(){

        @Override
        public Map<String, String> read(JsonReader reader) throws IOException {
            return reader.wasNull() ? null : MapConverter.deserialize(reader);
        }
    };

    public static void serializeNullable(Map<String, String> value, JsonWriter sw) {
        if (value == null) {
            sw.writeNull();
        } else {
            MapConverter.serialize(value, sw);
        }
    }

    public static void serialize(Map<String, String> value, JsonWriter sw) {
        sw.writeByte((byte)123);
        int size = value.size();
        if (size > 0) {
            Iterator<Map.Entry<String, String>> iterator = value.entrySet().iterator();
            Map.Entry<String, String> kv = iterator.next();
            StringConverter.serializeShort(kv.getKey(), sw);
            sw.writeByte((byte)58);
            StringConverter.serializeNullable(kv.getValue(), sw);
            for (int i = 1; i < size; ++i) {
                sw.writeByte((byte)44);
                kv = iterator.next();
                StringConverter.serializeShort(kv.getKey(), sw);
                sw.writeByte((byte)58);
                StringConverter.serializeNullable(kv.getValue(), sw);
            }
        }
        sw.writeByte((byte)125);
    }

    public static Map<String, String> deserialize(JsonReader reader) throws IOException {
        if (reader.last() != 123) {
            throw new IOException("Expecting '{' " + reader.positionDescription() + ". Found " + (char)reader.last());
        }
        byte nextToken = reader.getNextToken();
        if (nextToken == 125) {
            return new LinkedHashMap<String, String>(0);
        }
        LinkedHashMap<String, String> res = new LinkedHashMap<String, String>();
        String key = StringConverter.deserialize(reader);
        nextToken = reader.getNextToken();
        if (nextToken != 58) {
            throw new IOException("Expecting ':' " + reader.positionDescription() + ". Found " + (char)nextToken);
        }
        reader.getNextToken();
        String value = StringConverter.deserializeNullable(reader);
        res.put(key, value);
        while ((nextToken = reader.getNextToken()) == 44) {
            reader.getNextToken();
            key = StringConverter.deserialize(reader);
            nextToken = reader.getNextToken();
            if (nextToken != 58) {
                throw new IOException("Expecting ':' " + reader.positionDescription() + ". Found " + (char)nextToken);
            }
            reader.getNextToken();
            value = StringConverter.deserializeNullable(reader);
            res.put(key, value);
        }
        if (nextToken != 125) {
            throw new IOException("Expecting '}' " + reader.positionDescription() + ". Found " + (char)nextToken);
        }
        return res;
    }

    public static ArrayList<Map<String, String>> deserializeCollection(JsonReader reader) throws IOException {
        return reader.deserializeCollection(TypedMapReader);
    }

    public static void deserializeCollection(JsonReader reader, Collection<Map<String, String>> res) throws IOException {
        reader.deserializeCollection(TypedMapReader, res);
    }

    public static ArrayList<Map<String, String>> deserializeNullableCollection(JsonReader reader) throws IOException {
        return reader.deserializeNullableCollection(TypedMapReader);
    }

    public static void deserializeNullableCollection(JsonReader reader, Collection<Map<String, String>> res) throws IOException {
        reader.deserializeNullableCollection(TypedMapReader, res);
    }
}

