/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.shaded.dslplatform.json;

import co.elastic.apm.shaded.dslplatform.json.JsonReader;
import co.elastic.apm.shaded.dslplatform.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public abstract class BoolConverter {
    public static final JsonReader.ReadObject<Boolean> READER = new JsonReader.ReadObject<Boolean>(){

        @Override
        public Boolean read(JsonReader reader) throws IOException {
            return BoolConverter.deserialize(reader);
        }
    };
    public static final JsonReader.ReadObject<Boolean> NULLABLE_READER = new JsonReader.ReadObject<Boolean>(){

        @Override
        public Boolean read(JsonReader reader) throws IOException {
            return reader.wasNull() ? null : Boolean.valueOf(BoolConverter.deserialize(reader));
        }
    };
    public static final JsonWriter.WriteObject<Boolean> WRITER = new JsonWriter.WriteObject<Boolean>(){

        @Override
        public void write(JsonWriter writer, Boolean value) {
            BoolConverter.serializeNullable(value, writer);
        }
    };
    public static final JsonReader.ReadObject<boolean[]> ARRAY_READER = new JsonReader.ReadObject<boolean[]>(){

        @Override
        public boolean[] read(JsonReader reader) throws IOException {
            if (reader.wasNull()) {
                return null;
            }
            if (reader.last() != 91) {
                throw reader.expecting("[");
            }
            reader.getNextToken();
            return BoolConverter.deserializeBoolArray(reader);
        }
    };
    public static final JsonWriter.WriteObject<boolean[]> ARRAY_WRITER = new JsonWriter.WriteObject<boolean[]>(){

        @Override
        public void write(JsonWriter writer, boolean[] value) {
            BoolConverter.serialize(value, writer);
        }
    };

    public static void serializeNullable(Boolean value, JsonWriter sw) {
        if (value == null) {
            sw.writeNull();
        } else if (value.booleanValue()) {
            sw.writeAscii("true");
        } else {
            sw.writeAscii("false");
        }
    }

    public static void serialize(boolean value, JsonWriter sw) {
        if (value) {
            sw.writeAscii("true");
        } else {
            sw.writeAscii("false");
        }
    }

    public static void serialize(boolean[] value, JsonWriter sw) {
        if (value == null) {
            sw.writeNull();
        } else if (value.length == 0) {
            sw.writeAscii("[]");
        } else {
            sw.writeByte((byte)91);
            sw.writeAscii(value[0] ? "true" : "false");
            for (int i = 1; i < value.length; ++i) {
                sw.writeAscii(value[i] ? ",true" : ",false");
            }
            sw.writeByte((byte)93);
        }
    }

    public static boolean deserialize(JsonReader reader) throws IOException {
        if (reader.wasTrue()) {
            return true;
        }
        if (reader.wasFalse()) {
            return false;
        }
        throw new IOException("Found invalid boolean value " + reader.positionDescription());
    }

    public static boolean[] deserializeBoolArray(JsonReader reader) throws IOException {
        if (reader.last() == 93) {
            return new boolean[0];
        }
        boolean[] buffer = new boolean[4];
        buffer[0] = BoolConverter.deserialize(reader);
        int i = 1;
        while (reader.getNextToken() == 44) {
            reader.getNextToken();
            if (i == buffer.length) {
                buffer = Arrays.copyOf(buffer, buffer.length << 1);
            }
            buffer[i++] = BoolConverter.deserialize(reader);
        }
        reader.checkArrayEnd();
        return Arrays.copyOf(buffer, i);
    }

    public static ArrayList<Boolean> deserializeCollection(JsonReader reader) throws IOException {
        return reader.deserializeCollection(READER);
    }

    public static void deserializeCollection(JsonReader reader, Collection<Boolean> res) throws IOException {
        reader.deserializeCollection(READER, res);
    }

    public static ArrayList<Boolean> deserializeNullableCollection(JsonReader reader) throws IOException {
        return reader.deserializeNullableCollection(READER);
    }

    public static void deserializeNullableCollection(JsonReader reader, Collection<Boolean> res) throws IOException {
        reader.deserializeNullableCollection(READER, res);
    }
}

