/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.shaded.dslplatform.json;

import co.elastic.apm.shaded.dslplatform.json.JsonReader;
import co.elastic.apm.shaded.dslplatform.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;

public abstract class BinaryConverter {
    static final JsonReader.ReadObject<byte[]> Base64Reader = new JsonReader.ReadObject<byte[]>(){

        @Override
        public byte[] read(JsonReader reader) throws IOException {
            return reader.wasNull() ? null : BinaryConverter.deserialize(reader);
        }
    };
    static final JsonWriter.WriteObject<byte[]> Base64Writer = new JsonWriter.WriteObject<byte[]>(){

        @Override
        public void write(JsonWriter writer, byte[] value) {
            BinaryConverter.serialize(value, writer);
        }
    };

    public static void serialize(byte[] value, JsonWriter sw) {
        if (value == null) {
            sw.writeNull();
        } else if (value.length == 0) {
            sw.writeAscii("\"\"");
        } else {
            sw.writeBinary(value);
        }
    }

    public static byte[] deserialize(JsonReader reader) throws IOException {
        return reader.readBase64();
    }

    public static ArrayList<byte[]> deserializeCollection(JsonReader reader) throws IOException {
        return reader.deserializeCollection(Base64Reader);
    }

    public static void deserializeCollection(JsonReader reader, Collection<byte[]> res) throws IOException {
        reader.deserializeCollection(Base64Reader, res);
    }

    public static ArrayList<byte[]> deserializeNullableCollection(JsonReader reader) throws IOException {
        return reader.deserializeNullableCollection(Base64Reader);
    }

    public static void deserializeNullableCollection(JsonReader reader, Collection<byte[]> res) throws IOException {
        reader.deserializeNullableCollection(Base64Reader, res);
    }
}

