/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.shaded.dslplatform.json;

import java.util.Arrays;

abstract class Base64 {
    private static final char[] CA;
    private static final byte[] BA;
    private static final int[] IA;
    private static final byte[] EMPTY_ARRAY;

    Base64() {
    }

    static int encodeToBytes(byte[] sArr, byte[] dArr, int start) {
        int sLen = sArr.length;
        int eLen = sLen / 3 * 3;
        int dLen = (sLen - 1) / 3 + 1 << 2;
        int s = 0;
        int d = start;
        while (s < eLen) {
            int i = (sArr[s++] & 0xFF) << 16 | (sArr[s++] & 0xFF) << 8 | sArr[s++] & 0xFF;
            dArr[d++] = BA[i >>> 18 & 0x3F];
            dArr[d++] = BA[i >>> 12 & 0x3F];
            dArr[d++] = BA[i >>> 6 & 0x3F];
            dArr[d++] = BA[i & 0x3F];
        }
        int left = sLen - eLen;
        if (left > 0) {
            int i = (sArr[eLen] & 0xFF) << 10 | (left == 2 ? (sArr[sLen - 1] & 0xFF) << 2 : 0);
            dArr[start + dLen - 4] = BA[i >> 12];
            dArr[start + dLen - 3] = BA[i >>> 6 & 0x3F];
            dArr[start + dLen - 2] = left == 2 ? BA[i & 0x3F] : 61;
            dArr[start + dLen - 1] = 61;
        }
        return dLen;
    }

    static int findEnd(byte[] sArr, int start) {
        for (int i = start; i < sArr.length; ++i) {
            if (IA[sArr[i] & 0xFF] >= 0) continue;
            return i;
        }
        return sArr.length;
    }

    static byte[] decodeFast(byte[] sArr, int start, int end) {
        int sIx;
        int sLen = end - start;
        if (sLen == 0) {
            return EMPTY_ARRAY;
        }
        int eIx = end - 1;
        for (sIx = start; sIx < eIx && IA[sArr[sIx] & 0xFF] < 0; ++sIx) {
        }
        while (eIx > 0 && IA[sArr[eIx] & 0xFF] < 0) {
            --eIx;
        }
        int pad = sArr[eIx] == 61 ? (sArr[eIx - 1] == 61 ? 2 : 1) : 0;
        int cCnt = eIx - sIx + 1;
        int sepCnt = sLen > 76 ? (sArr[76] == 13 ? cCnt / 78 : 0) << 1 : 0;
        int len = ((cCnt - sepCnt) * 6 >> 3) - pad;
        byte[] dArr = new byte[len];
        int d = 0;
        int cc = 0;
        int eLen = len / 3 * 3;
        while (d < eLen) {
            int i = IA[sArr[sIx++]] << 18 | IA[sArr[sIx++]] << 12 | IA[sArr[sIx++]] << 6 | IA[sArr[sIx++]];
            dArr[d++] = (byte)(i >> 16);
            dArr[d++] = (byte)(i >> 8);
            dArr[d++] = (byte)i;
            if (sepCnt <= 0 || ++cc != 19) continue;
            sIx += 2;
            cc = 0;
        }
        if (d < len) {
            int i = 0;
            int j = 0;
            while (sIx <= eIx - pad) {
                i |= IA[sArr[sIx++]] << 18 - j * 6;
                ++j;
            }
            int r = 16;
            while (d < len) {
                dArr[d++] = (byte)(i >> r);
                r -= 8;
            }
        }
        return dArr;
    }

    static {
        int i;
        CA = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();
        IA = new int[256];
        Arrays.fill(IA, -1);
        int iS = CA.length;
        for (i = 0; i < iS; ++i) {
            Base64.IA[Base64.CA[i]] = i;
        }
        Base64.IA[61] = 0;
        BA = new byte[CA.length];
        for (i = 0; i < CA.length; ++i) {
            Base64.BA[i] = (byte)CA[i];
        }
        EMPTY_ARRAY = new byte[0];
    }
}

