/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.shaded.bytebuddy.implementation.bytecode.constant;

import co.elastic.apm.shaded.bytebuddy.build.HashCodeAndEqualsPlugin;
import co.elastic.apm.shaded.bytebuddy.implementation.Implementation;
import co.elastic.apm.shaded.bytebuddy.implementation.bytecode.StackManipulation;
import co.elastic.apm.shaded.bytebuddy.implementation.bytecode.StackSize;
import co.elastic.apm.shaded.bytebuddy.jar.asm.MethodVisitor;

public enum LongConstant implements StackManipulation
{
    ZERO(9),
    ONE(10);

    private static final StackManipulation.Size SIZE;
    private final int opcode;

    private LongConstant(int opcode) {
        this.opcode = opcode;
    }

    public static StackManipulation forValue(long value) {
        if (value == 0L) {
            return ZERO;
        }
        if (value == 1L) {
            return ONE;
        }
        return new ConstantPool(value);
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
        methodVisitor.visitInsn(this.opcode);
        return SIZE;
    }

    static {
        SIZE = StackSize.DOUBLE.toIncreasingSize();
    }

    @HashCodeAndEqualsPlugin.Enhance
    protected static class ConstantPool
    implements StackManipulation {
        private final long value;

        protected ConstantPool(long value) {
            this.value = value;
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
            methodVisitor.visitLdcInsn(this.value);
            return SIZE;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            return this.value == ((ConstantPool)object).value;
        }

        public int hashCode() {
            long l = this.value;
            return 17 * 31 + (int)(l ^ l >>> 32);
        }
    }
}

