/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.shaded.bytebuddy.implementation.bytecode;

import co.elastic.apm.shaded.bytebuddy.description.type.TypeDefinition;
import co.elastic.apm.shaded.bytebuddy.implementation.Implementation;
import co.elastic.apm.shaded.bytebuddy.implementation.bytecode.StackManipulation;
import co.elastic.apm.shaded.bytebuddy.implementation.bytecode.StackSize;
import co.elastic.apm.shaded.bytebuddy.jar.asm.MethodVisitor;

public enum Removal implements StackManipulation
{
    ZERO(StackSize.ZERO, 0){

        @Override
        public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
            return new StackManipulation.Size(0, 0);
        }
    }
    ,
    SINGLE(StackSize.SINGLE, 87),
    DOUBLE(StackSize.DOUBLE, 88);

    private final StackManipulation.Size size;
    private final int opcode;

    private Removal(StackSize stackSize, int opcode) {
        this.size = stackSize.toDecreasingSize();
        this.opcode = opcode;
    }

    public static StackManipulation of(TypeDefinition typeDefinition) {
        switch (typeDefinition.getStackSize()) {
            case SINGLE: {
                return SINGLE;
            }
            case DOUBLE: {
                return DOUBLE;
            }
            case ZERO: {
                return ZERO;
            }
        }
        throw new AssertionError();
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
        methodVisitor.visitInsn(this.opcode);
        return this.size;
    }
}

