/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.shaded.bytebuddy.asm;

import co.elastic.apm.shaded.bytebuddy.ClassFileVersion;
import co.elastic.apm.shaded.bytebuddy.asm.AsmVisitorWrapper;
import co.elastic.apm.shaded.bytebuddy.description.field.FieldDescription;
import co.elastic.apm.shaded.bytebuddy.description.field.FieldList;
import co.elastic.apm.shaded.bytebuddy.description.method.MethodList;
import co.elastic.apm.shaded.bytebuddy.description.type.TypeDescription;
import co.elastic.apm.shaded.bytebuddy.implementation.Implementation;
import co.elastic.apm.shaded.bytebuddy.jar.asm.ClassVisitor;
import co.elastic.apm.shaded.bytebuddy.jar.asm.MethodVisitor;
import co.elastic.apm.shaded.bytebuddy.jar.asm.Type;
import co.elastic.apm.shaded.bytebuddy.pool.TypePool;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;

public enum TypeConstantAdjustment implements AsmVisitorWrapper
{
    INSTANCE;


    @Override
    public int mergeWriter(int flags) {
        return flags;
    }

    @Override
    public int mergeReader(int flags) {
        return flags;
    }

    @Override
    public ClassVisitor wrap(TypeDescription instrumentedType, ClassVisitor classVisitor, Implementation.Context implementationContext, TypePool typePool, FieldList<FieldDescription.InDefinedShape> fields, MethodList<?> methods, int writerFlags, int readerFlags) {
        return new TypeConstantDissolvingClassVisitor(classVisitor);
    }

    protected static class TypeConstantDissolvingClassVisitor
    extends ClassVisitor {
        private boolean supportsTypeConstants;

        protected TypeConstantDissolvingClassVisitor(ClassVisitor classVisitor) {
            super(393216, classVisitor);
        }

        @Override
        public void visit(int version, int modifiers, String name, String signature, String superClassName, String[] interfaceName) {
            this.supportsTypeConstants = ClassFileVersion.ofMinorMajor(version).isAtLeast(ClassFileVersion.JAVA_V5);
            super.visit(version, modifiers, name, signature, superClassName, interfaceName);
        }

        @Override
        public MethodVisitor visitMethod(int modifiers, String name, String descriptor, String signature, String[] exception) {
            MethodVisitor methodVisitor = super.visitMethod(modifiers, name, descriptor, signature, exception);
            return this.supportsTypeConstants || methodVisitor == null ? methodVisitor : new TypeConstantDissolvingMethodVisitor(methodVisitor);
        }

        protected static class TypeConstantDissolvingMethodVisitor
        extends MethodVisitor {
            private static final String JAVA_LANG_CLASS = "java/lang/Class";
            private static final String FOR_NAME = "forName";
            private static final String DESCRIPTOR = "(Ljava/lang/String;)Ljava/lang/Class;";

            protected TypeConstantDissolvingMethodVisitor(MethodVisitor methodVisitor) {
                super(393216, methodVisitor);
            }

            @Override
            @SuppressFBWarnings(value={"SF_SWITCH_NO_DEFAULT"}, justification="Fall through to default case is intentional")
            public void visitLdcInsn(Object constant) {
                if (constant instanceof Type) {
                    Type type = (Type)constant;
                    switch (type.getSort()) {
                        case 9: 
                        case 10: {
                            super.visitLdcInsn(type.getInternalName().replace('/', '.'));
                            super.visitMethodInsn(184, JAVA_LANG_CLASS, FOR_NAME, DESCRIPTOR, false);
                            return;
                        }
                    }
                }
                super.visitLdcInsn(constant);
            }
        }
    }
}

