/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.shaded.bytebuddy;

import co.elastic.apm.shaded.bytebuddy.build.HashCodeAndEqualsPlugin;
import co.elastic.apm.shaded.bytebuddy.description.type.TypeDescription;
import co.elastic.apm.shaded.bytebuddy.utility.RandomString;

public interface NamingStrategy {
    public String subclass(TypeDescription.Generic var1);

    public String redefine(TypeDescription var1);

    public String rebase(TypeDescription var1);

    @HashCodeAndEqualsPlugin.Enhance
    public static class PrefixingRandom
    extends AbstractBase {
        private final String prefix;
        @HashCodeAndEqualsPlugin.ValueHandling(value=HashCodeAndEqualsPlugin.ValueHandling.Sort.IGNORE)
        private final RandomString randomString;

        public PrefixingRandom(String prefix) {
            this.prefix = prefix;
            this.randomString = new RandomString();
        }

        @Override
        protected String name(TypeDescription superClass) {
            return this.prefix + "." + superClass.getName() + "$" + this.randomString.nextString();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            return this.prefix.equals(((PrefixingRandom)object).prefix);
        }

        public int hashCode() {
            return 17 * 31 + this.prefix.hashCode();
        }
    }

    @HashCodeAndEqualsPlugin.Enhance
    public static class SuffixingRandom
    extends AbstractBase {
        public static final String BYTE_BUDDY_RENAME_PACKAGE = "co.elastic.apm.shaded.bytebuddy.renamed";
        public static final String NO_PREFIX = "";
        private static final String JAVA_PACKAGE = "java.";
        private final String suffix;
        private final String javaLangPackagePrefix;
        @HashCodeAndEqualsPlugin.ValueHandling(value=HashCodeAndEqualsPlugin.ValueHandling.Sort.IGNORE)
        private final RandomString randomString;
        private final BaseNameResolver baseNameResolver;

        public SuffixingRandom(String suffix) {
            this(suffix, BaseNameResolver.ForUnnamedType.INSTANCE);
        }

        public SuffixingRandom(String suffix, String javaLangPackagePrefix) {
            this(suffix, BaseNameResolver.ForUnnamedType.INSTANCE, javaLangPackagePrefix);
        }

        public SuffixingRandom(String suffix, BaseNameResolver baseNameResolver) {
            this(suffix, baseNameResolver, BYTE_BUDDY_RENAME_PACKAGE);
        }

        public SuffixingRandom(String suffix, BaseNameResolver baseNameResolver, String javaLangPackagePrefix) {
            this.suffix = suffix;
            this.baseNameResolver = baseNameResolver;
            this.javaLangPackagePrefix = javaLangPackagePrefix;
            this.randomString = new RandomString();
        }

        @Override
        protected String name(TypeDescription superClass) {
            String baseName = this.baseNameResolver.resolve(superClass);
            if (baseName.startsWith(JAVA_PACKAGE) && !this.javaLangPackagePrefix.equals(NO_PREFIX)) {
                baseName = this.javaLangPackagePrefix + "." + baseName;
            }
            return baseName + "$" + this.suffix + "$" + this.randomString.nextString();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            if (!this.suffix.equals(((SuffixingRandom)object).suffix)) {
                return false;
            }
            if (!this.javaLangPackagePrefix.equals(((SuffixingRandom)object).javaLangPackagePrefix)) {
                return false;
            }
            return this.baseNameResolver.equals(((SuffixingRandom)object).baseNameResolver);
        }

        public int hashCode() {
            return ((17 * 31 + this.suffix.hashCode()) * 31 + this.javaLangPackagePrefix.hashCode()) * 31 + this.baseNameResolver.hashCode();
        }

        public static interface BaseNameResolver {
            public String resolve(TypeDescription var1);

            @HashCodeAndEqualsPlugin.Enhance
            public static class ForFixedValue
            implements BaseNameResolver {
                private final String name;

                public ForFixedValue(String name) {
                    this.name = name;
                }

                @Override
                public String resolve(TypeDescription typeDescription) {
                    return this.name;
                }

                public boolean equals(Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    return this.name.equals(((ForFixedValue)object).name);
                }

                public int hashCode() {
                    return 17 * 31 + this.name.hashCode();
                }
            }

            @HashCodeAndEqualsPlugin.Enhance
            public static class ForGivenType
            implements BaseNameResolver {
                private final TypeDescription typeDescription;

                public ForGivenType(TypeDescription typeDescription) {
                    this.typeDescription = typeDescription;
                }

                @Override
                public String resolve(TypeDescription typeDescription) {
                    return this.typeDescription.getName();
                }

                public boolean equals(Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    return this.typeDescription.equals(((ForGivenType)object).typeDescription);
                }

                public int hashCode() {
                    return 17 * 31 + this.typeDescription.hashCode();
                }
            }

            public static enum ForUnnamedType implements BaseNameResolver
            {
                INSTANCE;


                @Override
                public String resolve(TypeDescription typeDescription) {
                    return typeDescription.getName();
                }
            }
        }
    }

    public static abstract class AbstractBase
    implements NamingStrategy {
        @Override
        public String subclass(TypeDescription.Generic superClass) {
            return this.name(superClass.asErasure());
        }

        protected abstract String name(TypeDescription var1);

        @Override
        public String redefine(TypeDescription typeDescription) {
            return typeDescription.getName();
        }

        @Override
        public String rebase(TypeDescription typeDescription) {
            return typeDescription.getName();
        }
    }
}

