/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.servlet;

import co.elastic.apm.bci.ElasticApmInstrumentation;
import co.elastic.apm.impl.ElasticApmTracer;
import co.elastic.apm.servlet.ServletApiAdvice;
import co.elastic.apm.shaded.bytebuddy.description.method.MethodDescription;
import co.elastic.apm.shaded.bytebuddy.description.type.TypeDescription;
import co.elastic.apm.shaded.bytebuddy.matcher.ElementMatcher;
import co.elastic.apm.shaded.bytebuddy.matcher.ElementMatchers;

public class ServletInstrumentation
extends ElasticApmInstrumentation {
    static final String SERVLET_API = "servlet-api";

    @Override
    public void init(ElasticApmTracer tracer) {
        ServletApiAdvice.init(tracer);
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.not(ElementMatchers.isInterface()).and(ElementMatchers.nameContains("Servlet").or(ElementMatchers.nameContainsIgnoreCase("jsp"))).and(ElementMatchers.hasSuperType(ElementMatchers.named("javax.servlet.http.HttpServlet")));
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("service").and(ElementMatchers.takesArgument(0, ElementMatchers.named("javax.servlet.http.HttpServletRequest"))).and(ElementMatchers.takesArgument(1, ElementMatchers.named("javax.servlet.http.HttpServletResponse")));
    }

    @Override
    public Class<?> getAdviceClass() {
        return ServletApiAdvice.class;
    }

    @Override
    public String getInstrumentationGroupName() {
        return SERVLET_API;
    }
}

