/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.servlet;

import co.elastic.apm.impl.ElasticApmTracer;
import co.elastic.apm.impl.context.Request;
import co.elastic.apm.impl.context.Response;
import co.elastic.apm.impl.transaction.Transaction;
import co.elastic.apm.servlet.ServletTransactionHelper;
import co.elastic.apm.shaded.bytebuddy.asm.Advice;
import java.security.Principal;
import java.util.Enumeration;
import javax.annotation.Nullable;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ServletApiAdvice {
    @Nullable
    public static ServletTransactionHelper servletTransactionHelper;

    static void init(ElasticApmTracer tracer) {
        servletTransactionHelper = new ServletTransactionHelper(tracer);
    }

    @Nullable
    @Advice.OnMethodEnter
    public static Transaction onEnterServletService(@Advice.Argument(value=0) ServletRequest servletRequest) {
        if (servletTransactionHelper != null && servletRequest instanceof HttpServletRequest && !Boolean.TRUE.equals(servletRequest.getAttribute("elastic.apm.servlet.request.exclude"))) {
            Principal userPrincipal;
            Enumeration headerNames;
            HttpServletRequest request = (HttpServletRequest)servletRequest;
            Transaction transaction = servletTransactionHelper.onBefore(request.getServletPath(), request.getPathInfo(), request.getRequestURI(), request.getHeader("User-Agent"), request.getHeader("Elastic-Apm-Traceparent"));
            if (transaction == null) {
                request.setAttribute("elastic.apm.servlet.request.exclude", (Object)Boolean.TRUE);
                return null;
            }
            Request req = transaction.getContext().getRequest();
            if (transaction.isSampled() && request.getCookies() != null) {
                for (Cookie cookie : request.getCookies()) {
                    req.addCookie(cookie.getName(), cookie.getValue());
                }
            }
            if ((headerNames = request.getHeaderNames()) != null) {
                while (headerNames.hasMoreElements()) {
                    String headerName = (String)headerNames.nextElement();
                    req.addHeader(headerName, request.getHeader(headerName));
                }
            }
            servletTransactionHelper.fillRequestContext(transaction, (userPrincipal = request.getUserPrincipal()) != null ? userPrincipal.getName() : null, request.getProtocol(), request.getMethod(), request.isSecure(), request.getScheme(), request.getServerName(), request.getServerPort(), request.getRequestURI(), request.getQueryString(), request.getRemoteAddr(), request.getRequestURL());
            return transaction;
        }
        return null;
    }

    @Advice.OnMethodExit(onThrowable=Exception.class)
    public static void onExitServletService(@Advice.Argument(value=0) ServletRequest servletRequest, @Advice.Argument(value=1) ServletResponse servletResponse, @Advice.Enter @Nullable Transaction transaction, @Advice.Thrown @Nullable Exception exception) {
        if (servletTransactionHelper != null && transaction != null && servletRequest instanceof HttpServletRequest && servletResponse instanceof HttpServletResponse) {
            HttpServletResponse response = (HttpServletResponse)servletResponse;
            HttpServletRequest request = (HttpServletRequest)servletRequest;
            Response resp = transaction.getContext().getResponse();
            for (String headerName : response.getHeaderNames()) {
                resp.addHeader(headerName, response.getHeader(headerName));
            }
            servletTransactionHelper.onAfter(transaction, exception, response.isCommitted(), response.getStatus(), request.getMethod(), request.getParameterMap());
        }
    }
}

