/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.report.serialize;

import co.elastic.apm.configuration.CoreConfiguration;
import co.elastic.apm.impl.context.Context;
import co.elastic.apm.impl.context.Request;
import co.elastic.apm.impl.context.Response;
import co.elastic.apm.impl.context.Socket;
import co.elastic.apm.impl.context.Url;
import co.elastic.apm.impl.context.User;
import co.elastic.apm.impl.error.ErrorCapture;
import co.elastic.apm.impl.error.ErrorPayload;
import co.elastic.apm.impl.error.ExceptionInfo;
import co.elastic.apm.impl.payload.Agent;
import co.elastic.apm.impl.payload.Framework;
import co.elastic.apm.impl.payload.Language;
import co.elastic.apm.impl.payload.Payload;
import co.elastic.apm.impl.payload.ProcessInfo;
import co.elastic.apm.impl.payload.RuntimeInfo;
import co.elastic.apm.impl.payload.Service;
import co.elastic.apm.impl.payload.SystemInfo;
import co.elastic.apm.impl.payload.TransactionPayload;
import co.elastic.apm.impl.stacktrace.Stacktrace;
import co.elastic.apm.impl.transaction.Db;
import co.elastic.apm.impl.transaction.Span;
import co.elastic.apm.impl.transaction.SpanContext;
import co.elastic.apm.impl.transaction.SpanCount;
import co.elastic.apm.impl.transaction.TraceContext;
import co.elastic.apm.impl.transaction.Transaction;
import co.elastic.apm.impl.transaction.TransactionId;
import co.elastic.apm.report.serialize.DateSerializer;
import co.elastic.apm.report.serialize.PayloadSerializer;
import co.elastic.apm.shaded.dslplatform.json.BoolConverter;
import co.elastic.apm.shaded.dslplatform.json.DslJson;
import co.elastic.apm.shaded.dslplatform.json.JsonWriter;
import co.elastic.apm.shaded.dslplatform.json.NumberConverter;
import co.elastic.apm.shaded.dslplatform.json.StringConverter;
import co.elastic.apm.shaded.dslplatform.json.UUIDConverter;
import co.elastic.apm.shaded.slf4j.Logger;
import co.elastic.apm.shaded.slf4j.LoggerFactory;
import co.elastic.apm.util.HexUtils;
import co.elastic.apm.util.PotentiallyMultiValuedMap;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class DslJsonSerializer
implements PayloadSerializer {
    static final int MAX_VALUE_LENGTH = 1024;
    private static final Logger logger = LoggerFactory.getLogger(DslJsonSerializer.class);
    private static final String[] DISALLOWED_IN_TAG_KEY = new String[]{".", "*", "\""};
    final JsonWriter jw;
    private final StringBuilder replaceBuilder = new StringBuilder(1024);
    private final DateSerializer dateSerializer;
    private final boolean distributedTracing;

    public DslJsonSerializer(CoreConfiguration config) {
        this.jw = new DslJson().newWriter();
        this.dateSerializer = new DateSerializer();
        this.distributedTracing = config.isDistributedTracingEnabled();
    }

    @Override
    public void serializePayload(OutputStream os, Payload payload) {
        if (logger.isTraceEnabled()) {
            logger.trace(this.toJsonString(payload));
        }
        this.jw.reset(os);
        if (payload instanceof TransactionPayload) {
            this.serializeTransactionPayload((TransactionPayload)payload);
        } else if (payload instanceof ErrorPayload) {
            this.serializeErrorPayload((ErrorPayload)payload);
        }
        this.jw.flush();
        this.jw.reset();
    }

    private void serializeErrorPayload(ErrorPayload payload) {
        this.jw.writeByte((byte)123);
        this.serializeService(payload.getService());
        this.serializeProcess(payload.getProcess());
        this.serializeSystem(payload.getSystem());
        this.serializeErrors(payload.getErrors());
        this.jw.writeByte((byte)125);
    }

    private void serializeErrors(List<ErrorCapture> errors) {
        this.writeFieldName("errors");
        this.jw.writeByte((byte)91);
        if (errors.size() > 0) {
            this.serializeError(errors.get(0));
            for (int i = 1; i < errors.size(); ++i) {
                this.jw.writeByte((byte)44);
                this.serializeError(errors.get(i));
            }
        }
        this.jw.writeByte((byte)93);
    }

    private void serializeError(ErrorCapture errorCapture) {
        this.jw.writeByte((byte)123);
        this.writeDateField("timestamp", errorCapture.getTimestamp());
        if (this.distributedTracing) {
            if (errorCapture.getTraceContext().hasContent()) {
                this.serializeTraceContext(errorCapture.getTraceContext());
            }
        } else {
            this.serializeTransactionReference(errorCapture);
        }
        this.serializeContext(errorCapture.getContext());
        this.serializeException(errorCapture.getException());
        this.jw.writeByte((byte)125);
    }

    private void serializeTransactionReference(ErrorCapture errorCapture) {
        if (errorCapture.getTransaction().hasContent()) {
            this.writeFieldName("transaction");
            this.jw.writeByte((byte)123);
            TransactionId transactionId = errorCapture.getTransaction().getTransactionId();
            this.writeFieldName("id");
            UUIDConverter.serialize(transactionId.getMostSignificantBits(), transactionId.getLeastSignificantBits(), this.jw);
            this.jw.writeByte((byte)125);
            this.jw.writeByte((byte)44);
        }
    }

    private void serializeException(ExceptionInfo exception) {
        this.writeFieldName("exception");
        this.jw.writeByte((byte)123);
        this.writeField("code", exception.getCode());
        this.writeField("message", exception.getMessage());
        this.serializeStacktrace(exception.getStacktrace());
        this.writeLastField("type", exception.getType());
        this.jw.writeByte((byte)125);
    }

    public String toJsonString(Payload payload) {
        this.jw.reset();
        if (payload instanceof TransactionPayload) {
            this.serializeTransactionPayload((TransactionPayload)payload);
        } else if (payload instanceof ErrorPayload) {
            this.serializeErrorPayload((ErrorPayload)payload);
        }
        String s = this.jw.toString();
        this.jw.reset();
        return s;
    }

    public String toJsonString(Transaction transaction) {
        this.jw.reset();
        this.serializeTransaction(transaction);
        String s = this.jw.toString();
        this.jw.reset();
        return s;
    }

    public String toJsonString(Span span) {
        this.jw.reset();
        this.serializeSpan(span);
        String s = this.jw.toString();
        this.jw.reset();
        return s;
    }

    public String toJsonString(ErrorCapture error) {
        this.jw.reset();
        this.serializeError(error);
        String s = this.jw.toString();
        this.jw.reset();
        return s;
    }

    private void serializeTransactionPayload(TransactionPayload payload) {
        this.jw.writeByte((byte)123);
        this.serializeService(payload.getService());
        this.serializeProcess(payload.getProcess());
        this.serializeSystem(payload.getSystem());
        this.serializeSpans(payload.getSpans());
        this.serializeTransactions(payload);
        this.jw.writeByte((byte)125);
    }

    private void serializeTransactions(TransactionPayload payload) {
        this.writeFieldName("transactions");
        this.jw.writeByte((byte)91);
        if (payload.getTransactions().size() > 0) {
            this.serializeTransactions(payload.getTransactions());
        }
        this.jw.writeByte((byte)93);
    }

    private void serializeService(Service service) {
        RuntimeInfo runtime;
        Language language;
        Framework framework;
        this.writeFieldName("service");
        this.jw.writeByte((byte)123);
        this.writeField("name", service.getName());
        this.writeField("environment", service.getEnvironment());
        Agent agent = service.getAgent();
        if (agent != null) {
            this.serializeAgent(agent);
        }
        if ((framework = service.getFramework()) != null) {
            this.serializeFramework(framework);
        }
        if ((language = service.getLanguage()) != null) {
            this.serializeLanguage(language);
        }
        if ((runtime = service.getRuntime()) != null) {
            this.serializeRuntime(runtime);
        }
        this.writeLastField("version", service.getVersion());
        this.jw.writeByte((byte)125);
        this.jw.writeByte((byte)44);
    }

    private void serializeAgent(Agent agent) {
        this.writeFieldName("agent");
        this.jw.writeByte((byte)123);
        this.writeField("name", agent.getName());
        this.writeLastField("version", agent.getVersion());
        this.jw.writeByte((byte)125);
        this.jw.writeByte((byte)44);
    }

    private void serializeFramework(Framework framework) {
        this.writeFieldName("framework");
        this.jw.writeByte((byte)123);
        this.writeField("name", framework.getName());
        this.writeLastField("version", framework.getVersion());
        this.jw.writeByte((byte)125);
        this.jw.writeByte((byte)44);
    }

    private void serializeLanguage(Language language) {
        this.writeFieldName("language");
        this.jw.writeByte((byte)123);
        this.writeField("name", language.getName());
        this.writeLastField("version", language.getVersion());
        this.jw.writeByte((byte)125);
        this.jw.writeByte((byte)44);
    }

    private void serializeRuntime(RuntimeInfo runtime) {
        this.writeFieldName("runtime");
        this.jw.writeByte((byte)123);
        this.writeField("name", runtime.getName());
        this.writeLastField("version", runtime.getVersion());
        this.jw.writeByte((byte)125);
        this.jw.writeByte((byte)44);
    }

    private void serializeProcess(ProcessInfo process) {
        this.writeFieldName("process");
        this.jw.writeByte((byte)123);
        this.writeField("pid", process.getPid());
        if (process.getPpid() != null) {
            this.writeField("ppid", process.getPpid());
        }
        List<String> argv = process.getArgv();
        this.writeField("argv", argv);
        this.writeLastField("title", process.getTitle());
        this.jw.writeByte((byte)125);
        this.jw.writeByte((byte)44);
    }

    private void serializeSystem(SystemInfo system) {
        this.writeFieldName("system");
        this.jw.writeByte((byte)123);
        this.writeField("architecture", system.getArchitecture());
        this.writeField("hostname", system.getHostname());
        this.writeLastField("platform", system.getPlatform());
        this.jw.writeByte((byte)125);
        this.jw.writeByte((byte)44);
    }

    private void serializeTransactions(List<Transaction> transactions) {
        this.serializeTransaction(transactions.get(0));
        for (int i = 1; i < transactions.size(); ++i) {
            this.jw.writeByte((byte)44);
            this.serializeTransaction(transactions.get(i));
        }
    }

    private void serializeTransaction(Transaction transaction) {
        this.jw.writeByte((byte)123);
        this.writeDateField("timestamp", transaction.getTimestamp());
        this.writeField("name", transaction.getName());
        if (this.distributedTracing) {
            this.serializeTraceContext(transaction.getTraceContext());
        } else {
            this.writeField("id", transaction.getId());
        }
        this.writeField("type", transaction.getType());
        this.writeField("duration", transaction.getDuration());
        this.writeField("result", transaction.getResult());
        this.serializeContext(transaction.getContext());
        if (transaction.getSpanCount().getDropped().getTotal() > 0) {
            this.serializeSpanCount(transaction.getSpanCount());
        }
        this.serializeSpans(transaction.getSpans());
        this.writeLastField("sampled", transaction.isSampled());
        this.jw.writeByte((byte)125);
    }

    private void serializeTraceContext(TraceContext traceContext) {
        this.writeHexField("trace_id", traceContext.getTraceId().getBytes());
        this.writeHexField("id", traceContext.getId().getBytes());
        if (traceContext.getParentId().asLong() != 0L) {
            this.writeHexField("parent_id", traceContext.getParentId().getBytes());
        }
    }

    private void serializeSpans(List<Span> spans) {
        if (spans.size() > 0) {
            this.writeFieldName("spans");
            this.jw.writeByte((byte)91);
            this.serializeSpan(spans.get(0));
            for (int i = 1; i < spans.size(); ++i) {
                this.jw.writeByte((byte)44);
                this.serializeSpan(spans.get(i));
            }
            this.jw.writeByte((byte)93);
            this.jw.writeByte((byte)44);
        }
    }

    private void serializeSpan(Span span) {
        this.jw.writeByte((byte)123);
        this.writeField("name", span.getName());
        this.writeDateField("timestamp", span.getTimestamp());
        if (this.distributedTracing) {
            this.serializeTraceContext(span.getTraceContext());
            Transaction transaction = span.getTransaction();
            if (transaction != null) {
                this.writeHexField("transaction_id", transaction.getTraceContext().getId().getBytes());
            }
        } else {
            this.writeField("id", span.getId().asLong());
            long parent = span.getParent().asLong();
            if (parent != 0L) {
                this.writeField("parent", parent);
            }
        }
        this.writeField("duration", span.getDuration());
        this.writeField("start", span.getStart());
        if (span.getStacktrace().size() > 0) {
            this.serializeStacktrace(span.getStacktrace());
        }
        if (span.getContext().hasContent()) {
            this.serializeSpanContext(span.getContext());
        }
        this.writeLastField("type", span.getType());
        this.jw.writeByte((byte)125);
    }

    private void serializeStacktrace(List<Stacktrace> stacktrace) {
        if (stacktrace.size() > 0) {
            this.writeFieldName("stacktrace");
            this.jw.writeByte((byte)91);
            this.serializeStackTraceElement(stacktrace.get(0));
            for (int i = 1; i < stacktrace.size(); ++i) {
                this.jw.writeByte((byte)44);
                this.serializeStackTraceElement(stacktrace.get(i));
            }
            this.jw.writeByte((byte)93);
            this.jw.writeByte((byte)44);
        }
    }

    private void serializeStackTraceElement(Stacktrace stacktrace) {
        this.jw.writeByte((byte)123);
        this.writeField("filename", stacktrace.getFilename());
        this.writeField("function", stacktrace.getFunction());
        this.writeField("library_frame", stacktrace.isLibraryFrame());
        this.writeField("lineno", stacktrace.getLineno());
        this.writeField("module", stacktrace.getModule());
        this.writeLastField("abs_path", stacktrace.getAbsPath());
        this.jw.writeByte((byte)125);
    }

    private void serializeSpanContext(SpanContext context) {
        this.writeFieldName("context");
        this.jw.writeByte((byte)123);
        this.writeFieldName("db");
        this.jw.writeByte((byte)123);
        Db db = context.getDb();
        this.writeField("instance", db.getInstance());
        this.writeField("statement", db.getStatement());
        this.writeField("type", db.getType());
        this.writeLastField("user", db.getUser());
        this.jw.writeByte((byte)125);
        this.jw.writeByte((byte)125);
        this.jw.writeByte((byte)44);
    }

    private void serializeSpanCount(SpanCount spanCount) {
        this.writeFieldName("span_count");
        this.jw.writeByte((byte)123);
        this.writeFieldName("dropped");
        this.jw.writeByte((byte)123);
        this.writeFieldName("total");
        NumberConverter.serialize(spanCount.getDropped().getTotal(), this.jw);
        this.jw.writeByte((byte)125);
        this.jw.writeByte((byte)125);
        this.jw.writeByte((byte)44);
    }

    private void serializeContext(Context context) {
        this.writeFieldName("context");
        this.jw.writeByte((byte)123);
        if (context.getUser().hasContent()) {
            this.serializeUser(context.getUser());
            this.jw.writeByte((byte)44);
        }
        this.serializeRequest(context.getRequest());
        this.serializeResponse(context.getResponse());
        this.writeFieldName("tags");
        Map<String, String> value = context.getTags();
        this.serializeTags(value);
        this.jw.writeByte((byte)125);
        this.jw.writeByte((byte)44);
    }

    void serializeTags(Map<String, String> value) {
        this.jw.writeByte((byte)123);
        int size = value.size();
        if (size > 0) {
            Iterator<Map.Entry<String, String>> iterator = value.entrySet().iterator();
            Map.Entry<String, String> kv = iterator.next();
            this.jw.writeString(this.sanitizeTagKey(kv.getKey()));
            this.jw.writeByte((byte)58);
            StringConverter.serializeNullable(kv.getValue(), this.jw);
            for (int i = 1; i < size; ++i) {
                this.jw.writeByte((byte)44);
                kv = iterator.next();
                this.jw.writeString(this.sanitizeTagKey(kv.getKey()));
                this.jw.writeByte((byte)58);
                StringConverter.serializeNullable(kv.getValue(), this.jw);
            }
        }
        this.jw.writeByte((byte)125);
    }

    private CharSequence sanitizeTagKey(String key) {
        for (int i = 0; i < DISALLOWED_IN_TAG_KEY.length; ++i) {
            if (!key.contains(DISALLOWED_IN_TAG_KEY[i])) continue;
            return this.replaceAll(key, DISALLOWED_IN_TAG_KEY, "_");
        }
        return key;
    }

    private CharSequence replaceAll(String s, String[] stringsToReplace, String replacement) {
        this.replaceBuilder.setLength(0);
        this.replaceBuilder.append(s);
        for (String toReplace : stringsToReplace) {
            this.replace(this.replaceBuilder, toReplace, replacement);
        }
        return this.replaceBuilder;
    }

    private void replace(StringBuilder replaceBuilder, String toReplace, String replacement) {
        int i = replaceBuilder.indexOf(toReplace);
        while (i != -1) {
            replaceBuilder.replace(i, i + replacement.length(), replacement);
            i = replaceBuilder.indexOf(toReplace);
        }
    }

    private void serializeResponse(Response response) {
        if (response.hasContent()) {
            this.writeFieldName("response");
            this.jw.writeByte((byte)123);
            this.writeField("headers", response.getHeaders());
            this.writeField("finished", response.isFinished());
            this.writeField("headers_sent", response.isHeadersSent());
            this.writeFieldName("status_code");
            NumberConverter.serialize(response.getStatusCode(), this.jw);
            this.jw.writeByte((byte)125);
            this.jw.writeByte((byte)44);
        }
    }

    private void serializeRequest(Request request) {
        if (request.hasContent()) {
            this.writeFieldName("request");
            this.jw.writeByte((byte)123);
            this.writeField("method", request.getMethod());
            this.writeField("headers", request.getHeaders());
            this.writeField("cookies", request.getCookies());
            this.writeField("body", request.getFormUrlEncodedParameters());
            this.writeField("body", request.getRawBody());
            if (request.getUrl().hasContent()) {
                this.serializeUrl(request.getUrl());
            }
            if (request.getSocket().hasContent()) {
                this.serializeSocket(request.getSocket());
            }
            this.writeLastField("http_version", request.getHttpVersion());
            this.jw.writeByte((byte)125);
            this.jw.writeByte((byte)44);
        }
    }

    private void serializeUrl(Url url) {
        this.writeFieldName("url");
        this.jw.writeByte((byte)123);
        this.writeField("full", url.getFull());
        this.writeField("hostname", url.getHostname());
        this.writeField("port", url.getPort());
        this.writeField("pathname", url.getPathname());
        this.writeField("search", url.getSearch());
        this.writeLastField("protocol", url.getProtocol());
        this.jw.writeByte((byte)125);
        this.jw.writeByte((byte)44);
    }

    private void serializeSocket(Socket socket) {
        this.writeFieldName("socket");
        this.jw.writeByte((byte)123);
        this.writeField("encrypted", socket.isEncrypted());
        this.writeLastField("remote_address", socket.getRemoteAddress());
        this.jw.writeByte((byte)125);
        this.jw.writeByte((byte)44);
    }

    private void writeField(String fieldName, PotentiallyMultiValuedMap map) {
        if (map.size() > 0) {
            this.writeFieldName(fieldName);
            this.jw.writeByte((byte)123);
            int size = map.size();
            if (size > 0) {
                this.serializePotentiallyMultiValuedEntry(map.getKey(0), map.getValue(0));
                for (int i = 1; i < size; ++i) {
                    this.jw.writeByte((byte)44);
                    this.serializePotentiallyMultiValuedEntry(map.getKey(i), map.getValue(i));
                }
            }
            this.jw.writeByte((byte)125);
            this.jw.writeByte((byte)44);
        }
    }

    private void serializePotentiallyMultiValuedEntry(String key, @Nullable Object value) {
        this.jw.writeString(key);
        this.jw.writeByte((byte)58);
        if (value instanceof String) {
            StringConverter.serialize((String)value, this.jw);
        } else if (value instanceof List) {
            this.jw.writeByte((byte)91);
            List values = (List)value;
            this.jw.writeString((String)values.get(0));
            for (int i = 1; i < values.size(); ++i) {
                this.jw.writeByte((byte)44);
                this.jw.writeString((String)values.get(i));
            }
            this.jw.writeByte((byte)93);
        } else if (value == null) {
            this.jw.writeNull();
        }
    }

    private void serializeUser(User user) {
        this.writeFieldName("user");
        this.jw.writeByte((byte)123);
        this.writeField("id", user.getId());
        this.writeField("email", user.getEmail());
        this.writeLastField("username", user.getUsername());
        this.jw.writeByte((byte)125);
    }

    void writeField(String fieldName, StringBuilder value) {
        if (value.length() > 0) {
            this.writeFieldName(fieldName);
            this.writeStringBuilderValue(value);
            this.jw.writeByte((byte)44);
        }
    }

    void writeField(String fieldName, @Nullable String value) {
        if (value != null) {
            this.writeFieldName(fieldName);
            this.writeStringValue(value);
            this.jw.writeByte((byte)44);
        }
    }

    private void writeStringBuilderValue(StringBuilder value) {
        if (value.length() > 1024) {
            value.setLength(1023);
            value.append('\u2026');
        }
        this.jw.writeString(value);
    }

    private void writeStringValue(String value) {
        if (value.length() > 1024) {
            this.replaceBuilder.setLength(0);
            this.replaceBuilder.append(value, 0, Math.min(value.length(), 1024));
            this.writeStringBuilderValue(this.replaceBuilder);
        } else {
            this.jw.writeString(value);
        }
    }

    private void writeField(String fieldName, long value) {
        this.writeFieldName(fieldName);
        NumberConverter.serialize(value, this.jw);
        this.jw.writeByte((byte)44);
    }

    private void writeField(String fieldName, boolean value) {
        this.writeFieldName(fieldName);
        BoolConverter.serialize(value, this.jw);
        this.jw.writeByte((byte)44);
    }

    private void writeLastField(String fieldName, boolean value) {
        this.writeFieldName(fieldName);
        BoolConverter.serialize(value, this.jw);
    }

    private void writeField(String fieldName, double value) {
        this.writeFieldName(fieldName);
        NumberConverter.serialize(value, this.jw);
        this.jw.writeByte((byte)44);
    }

    void writeLastField(String fieldName, @Nullable String value) {
        this.writeFieldName(fieldName);
        if (value != null) {
            this.writeStringValue(value);
        } else {
            this.jw.writeNull();
        }
    }

    private void writeFieldName(String fieldName) {
        this.jw.writeByte((byte)34);
        this.jw.writeAscii(fieldName);
        this.jw.writeByte((byte)34);
        this.jw.writeByte((byte)58);
    }

    private void writeField(String fieldName, List<String> values) {
        if (values.size() > 0) {
            this.writeFieldName(fieldName);
            this.jw.writeByte((byte)91);
            this.jw.writeString(values.get(0));
            for (int i = 1; i < values.size(); ++i) {
                this.jw.writeByte((byte)44);
                this.jw.writeString(values.get(i));
            }
            this.jw.writeByte((byte)93);
            this.jw.writeByte((byte)44);
        }
    }

    private void writeField(String fieldName, TransactionId id) {
        this.writeFieldName(fieldName);
        UUIDConverter.serialize(id.getMostSignificantBits(), id.getLeastSignificantBits(), this.jw);
        this.jw.writeByte((byte)44);
    }

    private void writeHexField(String fieldName, byte[] value) {
        this.writeFieldName(fieldName);
        this.jw.writeByte((byte)34);
        HexUtils.writeBytesAsHex(value, this.jw);
        this.jw.writeByte((byte)34);
        this.jw.writeByte((byte)44);
    }

    private void writeDateField(String fieldName, long timestamp) {
        this.writeFieldName(fieldName);
        this.jw.writeByte((byte)34);
        this.dateSerializer.serializeEpochTimestampAsIsoDateTime(this.jw, timestamp);
        this.jw.writeByte((byte)34);
        this.jw.writeByte((byte)44);
    }
}

