/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.report.serialize;

import co.elastic.apm.shaded.dslplatform.json.JsonWriter;
import co.elastic.apm.shaded.dslplatform.json.NumberConverter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

class DateSerializer {
    private static final long MILLIS_PER_SECOND = 1000L;
    private static final long MILLIS_PER_MINUTE = 60000L;
    private static final long MILLIS_PER_HOUR = 3600000L;
    private static final long MILLIS_PER_DAY = 86400000L;
    private static final byte TIME_SEPARATOR = 84;
    private static final byte TIME_ZONE_SEPARATOR = 90;
    private static final byte COLON = 58;
    private static final byte DOT = 46;
    private static final byte ZERO = 48;
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private String cachedDateIso;
    private long startOfCachedDate;
    private long endOfCachedDate;

    DateSerializer() {
        this.dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.cacheDate(System.currentTimeMillis());
    }

    private static long atStartOfDay(long epochTimestamp) {
        return epochTimestamp - epochTimestamp % 86400000L;
    }

    private static long atEndOfDay(long epochTimestamp) {
        return DateSerializer.atStartOfDay(epochTimestamp) + 86400000L - 1L;
    }

    void serializeEpochTimestampAsIsoDateTime(JsonWriter jw, long epochTimestamp) {
        if (!this.isDateCached(epochTimestamp)) {
            this.cacheDate(epochTimestamp);
        }
        jw.writeAscii(this.cachedDateIso);
        jw.writeByte((byte)84);
        long remainder = epochTimestamp % 86400000L;
        this.serializeWithLeadingZero(jw, remainder / 3600000L, 2);
        jw.writeByte((byte)58);
        this.serializeWithLeadingZero(jw, (remainder %= 3600000L) / 60000L, 2);
        jw.writeByte((byte)58);
        this.serializeWithLeadingZero(jw, (remainder %= 60000L) / 1000L, 2);
        jw.writeByte((byte)46);
        this.serializeWithLeadingZero(jw, remainder %= 1000L, 3);
        jw.writeByte((byte)90);
    }

    private void serializeWithLeadingZero(JsonWriter jw, long value, int minLength) {
        for (int i = minLength - 1; i > 0; --i) {
            if (!((double)value < Math.pow(10.0, i))) continue;
            jw.writeByte((byte)48);
        }
        NumberConverter.serialize(value, jw);
    }

    private void cacheDate(long epochTimestamp) {
        this.cachedDateIso = this.dateFormat.format(new Date(epochTimestamp));
        this.startOfCachedDate = DateSerializer.atStartOfDay(epochTimestamp);
        this.endOfCachedDate = DateSerializer.atEndOfDay(epochTimestamp);
    }

    private boolean isDateCached(long epochTimestamp) {
        return epochTimestamp >= this.startOfCachedDate && epochTimestamp <= this.endOfCachedDate;
    }
}

