/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.report.processor;

import co.elastic.apm.report.ReportingEvent;
import co.elastic.apm.report.processor.Processor;
import co.elastic.apm.shaded.lmax.disruptor.EventHandler;
import co.elastic.apm.shaded.stagemonitor.configuration.ConfigurationRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;

public class ProcessorEventHandler
implements EventHandler<ReportingEvent> {
    private final List<Processor> processors = new ArrayList<Processor>();

    public ProcessorEventHandler(Iterable<Processor> processors) {
        for (Processor processor : processors) {
            this.processors.add(processor);
        }
    }

    public static ProcessorEventHandler loadProcessors(ConfigurationRegistry configurationRegistry) {
        ServiceLoader<Processor> processors = ServiceLoader.load(Processor.class, ProcessorEventHandler.class.getClassLoader());
        for (Processor processor : processors) {
            processor.init(configurationRegistry);
        }
        return new ProcessorEventHandler(processors);
    }

    @Override
    public void onEvent(ReportingEvent event, long sequence, boolean endOfBatch) {
        block3: {
            block2: {
                if (event.getTransaction() == null) break block2;
                for (int i = 0; i < this.processors.size(); ++i) {
                    this.processors.get(i).processBeforeReport(event.getTransaction());
                }
                break block3;
            }
            if (event.getError() == null) break block3;
            for (int i = 0; i < this.processors.size(); ++i) {
                this.processors.get(i).processBeforeReport(event.getError());
            }
        }
    }
}

