/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.report;

import co.elastic.apm.impl.error.ErrorPayload;
import co.elastic.apm.impl.payload.Payload;
import co.elastic.apm.impl.payload.ProcessInfo;
import co.elastic.apm.impl.payload.Service;
import co.elastic.apm.impl.payload.SystemInfo;
import co.elastic.apm.impl.payload.TransactionPayload;
import co.elastic.apm.report.PayloadSender;
import co.elastic.apm.report.ReporterConfiguration;
import co.elastic.apm.report.ReportingEvent;
import co.elastic.apm.report.processor.ProcessorEventHandler;
import co.elastic.apm.shaded.lmax.disruptor.EventHandler;
import co.elastic.apm.shaded.slf4j.Logger;
import co.elastic.apm.shaded.slf4j.LoggerFactory;

class ReportingEventHandler
implements EventHandler<ReportingEvent> {
    private static final Logger logger = LoggerFactory.getLogger(ReportingEventHandler.class);
    private final TransactionPayload transactionPayload;
    private final ErrorPayload errorPayload;
    private final PayloadSender payloadSender;
    private final ReporterConfiguration reporterConfiguration;
    private final ProcessorEventHandler processorEventHandler;

    public ReportingEventHandler(Service service, ProcessInfo process, SystemInfo system, PayloadSender payloadSender, ReporterConfiguration reporterConfiguration, ProcessorEventHandler processorEventHandler) {
        this.payloadSender = payloadSender;
        this.reporterConfiguration = reporterConfiguration;
        this.processorEventHandler = processorEventHandler;
        this.transactionPayload = new TransactionPayload(process, service, system);
        this.errorPayload = new ErrorPayload(process, service, system);
    }

    @Override
    public void onEvent(ReportingEvent event, long sequence, boolean endOfBatch) {
        if (logger.isTraceEnabled()) {
            logger.trace("Receiving {} event (sequence {})", (Object)event.getType(), (Object)sequence);
        }
        this.processorEventHandler.onEvent(event, sequence, endOfBatch);
        if (event.getType() == ReportingEvent.ReportingEventType.FLUSH) {
            this.flush(this.transactionPayload);
            this.flush(this.errorPayload);
        }
        if (event.getType() == ReportingEvent.ReportingEventType.TRANSACTION) {
            this.transactionPayload.getTransactions().add(event.getTransaction());
            if (this.transactionPayload.getTransactions().size() >= this.reporterConfiguration.getMaxQueueSize()) {
                this.flush(this.transactionPayload);
            }
        }
        if (event.getType() == ReportingEvent.ReportingEventType.SPAN) {
            this.transactionPayload.getSpans().add(event.getSpan());
        }
        if (event.getType() == ReportingEvent.ReportingEventType.ERROR) {
            this.errorPayload.getErrors().add(event.getError());
            if (endOfBatch) {
                this.flush(this.errorPayload);
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace("Finished processing {} event (sequence {})", (Object)event.getType(), (Object)sequence);
        }
        event.resetState();
    }

    private void flush(Payload payload) {
        if (payload.getPayloadObjects().isEmpty()) {
            return;
        }
        try {
            this.payloadSender.sendPayload(payload);
        }
        finally {
            payload.resetState();
        }
    }
}

