/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.report;

import co.elastic.apm.configuration.CoreConfiguration;
import co.elastic.apm.impl.payload.ProcessFactory;
import co.elastic.apm.impl.payload.ServiceFactory;
import co.elastic.apm.impl.payload.SystemInfo;
import co.elastic.apm.report.ApmServerHttpPayloadSender;
import co.elastic.apm.report.ApmServerReporter;
import co.elastic.apm.report.Reporter;
import co.elastic.apm.report.ReporterConfiguration;
import co.elastic.apm.report.processor.ProcessorEventHandler;
import co.elastic.apm.report.serialize.DslJsonSerializer;
import co.elastic.apm.shaded.okhttp3.OkHttpClient;
import co.elastic.apm.shaded.okhttp3.logging.HttpLoggingInterceptor;
import co.elastic.apm.shaded.slf4j.Logger;
import co.elastic.apm.shaded.slf4j.LoggerFactory;
import co.elastic.apm.shaded.stagemonitor.configuration.ConfigurationRegistry;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class ReporterFactory {
    private static final Logger logger = LoggerFactory.getLogger(ReporterFactory.class);

    public Reporter createReporter(ConfigurationRegistry configurationRegistry, @Nullable String frameworkName, @Nullable String frameworkVersion) {
        ReporterConfiguration reporterConfiguration = configurationRegistry.getConfig(ReporterConfiguration.class);
        DslJsonSerializer payloadSerializer = new DslJsonSerializer(configurationRegistry.getConfig(CoreConfiguration.class));
        return new ApmServerReporter(new ServiceFactory().createService(configurationRegistry.getConfig(CoreConfiguration.class), frameworkName, frameworkVersion), ProcessFactory.ForCurrentVM.INSTANCE.getProcessInformation(), SystemInfo.create(), new ApmServerHttpPayloadSender(this.getOkHttpClient(reporterConfiguration), payloadSerializer, reporterConfiguration), true, reporterConfiguration, ProcessorEventHandler.loadProcessors(configurationRegistry), configurationRegistry.getConfig(CoreConfiguration.class));
    }

    @Nonnull
    OkHttpClient getOkHttpClient(ReporterConfiguration reporterConfiguration) {
        OkHttpClient.Builder builder = new OkHttpClient.Builder().connectTimeout(reporterConfiguration.getServerTimeout(), TimeUnit.SECONDS);
        if (!reporterConfiguration.isVerifyServerCert()) {
            this.disableCertificateValidation(builder);
        }
        if (logger.isTraceEnabled()) {
            HttpLoggingInterceptor loggingInterceptor = new HttpLoggingInterceptor();
            loggingInterceptor.setLevel(HttpLoggingInterceptor.Level.HEADERS);
            builder.addInterceptor(loggingInterceptor);
        }
        return builder.build();
    }

    private void disableCertificateValidation(OkHttpClient.Builder builder) {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        }};
        try {
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, trustAllCerts, new SecureRandom());
            SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
            builder.sslSocketFactory(sslSocketFactory, (X509TrustManager)trustAllCerts[0]).hostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            });
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            logger.warn(e.getMessage(), e);
        }
    }
}

